/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.block.BlockBuilder;
import com.facebook.presto.block.BlockCursor;
import com.facebook.presto.operator.aggregation.FixedWidthAggregationFunction;
import com.facebook.presto.tuple.TupleInfo;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;

public abstract class AbstractVarianceAggregation
implements FixedWidthAggregationFunction {
    protected final boolean population;
    static final TupleInfo VARIANCE_CONTEXT_INFO = new TupleInfo(TupleInfo.Type.FIXED_INT_64, TupleInfo.Type.DOUBLE, TupleInfo.Type.DOUBLE);

    AbstractVarianceAggregation(boolean population) {
        this.population = population;
    }

    @Override
    public TupleInfo getFinalTupleInfo() {
        return TupleInfo.SINGLE_DOUBLE;
    }

    @Override
    public TupleInfo getIntermediateTupleInfo() {
        return TupleInfo.SINGLE_VARBINARY;
    }

    @Override
    public int getFixedSize() {
        return VARIANCE_CONTEXT_INFO.getFixedSize();
    }

    @Override
    public void initialize(Slice valueSlice, int valueOffset) {
        VARIANCE_CONTEXT_INFO.setNull(valueSlice, valueOffset, 0);
        VARIANCE_CONTEXT_INFO.setNotNull(valueSlice, valueOffset, 1);
        VARIANCE_CONTEXT_INFO.setDouble(valueSlice, valueOffset, 1, 0.0);
        VARIANCE_CONTEXT_INFO.setNotNull(valueSlice, valueOffset, 2);
        VARIANCE_CONTEXT_INFO.setDouble(valueSlice, valueOffset, 2, 0.0);
    }

    @Override
    public void evaluateIntermediate(Slice valueSlice, int valueOffset, BlockBuilder output) {
        boolean isEmpty = VARIANCE_CONTEXT_INFO.isNull(valueSlice, valueOffset, 0);
        if (isEmpty) {
            output.appendNull();
            return;
        }
        long count = VARIANCE_CONTEXT_INFO.getLong(valueSlice, valueOffset, 0);
        double mean = VARIANCE_CONTEXT_INFO.getDouble(valueSlice, valueOffset, 1);
        double m2 = VARIANCE_CONTEXT_INFO.getDouble(valueSlice, valueOffset, 2);
        Slice intermediateValue = Slices.allocate((int)VARIANCE_CONTEXT_INFO.getFixedSize());
        VARIANCE_CONTEXT_INFO.setNotNull(intermediateValue, 0);
        VARIANCE_CONTEXT_INFO.setLong(intermediateValue, 0, count);
        VARIANCE_CONTEXT_INFO.setDouble(intermediateValue, 1, mean);
        VARIANCE_CONTEXT_INFO.setDouble(intermediateValue, 2, m2);
        output.append(intermediateValue);
    }

    @Override
    public void addIntermediate(BlockCursor cursor, int field, Slice valueSlice, int valueOffset) {
        double totalM2;
        double totalMean;
        long totalCount;
        if (cursor.isNull(field)) {
            return;
        }
        Slice otherVariance = cursor.getSlice(field);
        long otherCount = VARIANCE_CONTEXT_INFO.getLong(otherVariance, 0);
        double otherMean = VARIANCE_CONTEXT_INFO.getDouble(otherVariance, 1);
        double otherM2 = VARIANCE_CONTEXT_INFO.getDouble(otherVariance, 2);
        if (VARIANCE_CONTEXT_INFO.isNull(valueSlice, valueOffset, 0)) {
            totalCount = otherCount;
            totalMean = otherMean;
            totalM2 = otherM2;
        } else {
            long count = VARIANCE_CONTEXT_INFO.getLong(valueSlice, valueOffset, 0);
            double mean = VARIANCE_CONTEXT_INFO.getDouble(valueSlice, valueOffset, 1);
            double m2 = VARIANCE_CONTEXT_INFO.getDouble(valueSlice, valueOffset, 2);
            double delta = otherMean - mean;
            totalCount = count + otherCount;
            totalMean = ((double)count * mean + (double)otherCount * otherMean) / (double)totalCount;
            totalM2 = m2 + otherM2 + delta * delta * (double)(count * otherCount) / (double)totalCount;
        }
        VARIANCE_CONTEXT_INFO.setNotNull(valueSlice, valueOffset, 0);
        VARIANCE_CONTEXT_INFO.setLong(valueSlice, valueOffset, 0, totalCount);
        VARIANCE_CONTEXT_INFO.setDouble(valueSlice, valueOffset, 1, totalMean);
        VARIANCE_CONTEXT_INFO.setDouble(valueSlice, valueOffset, 2, totalM2);
    }

    static Double buildFinalVariance(boolean population, Slice valueSlice, int valueOffset) {
        if (VARIANCE_CONTEXT_INFO.isNull(valueSlice, valueOffset, 0)) {
            return null;
        }
        long count = VARIANCE_CONTEXT_INFO.getLong(valueSlice, valueOffset, 0);
        double m2 = VARIANCE_CONTEXT_INFO.getDouble(valueSlice, valueOffset, 2);
        if (population) {
            return m2 / (double)count;
        }
        return count == 1L ? null : Double.valueOf(m2 / (double)(count - 1L));
    }

    static Double buildFinalStdDev(boolean population, Slice valueSlice, int valueOffset) {
        Double variance = AbstractVarianceAggregation.buildFinalVariance(population, valueSlice, valueOffset);
        return variance == null ? null : Double.valueOf(Math.sqrt(variance));
    }

    @Override
    public void evaluateFinal(Slice valueSlice, int valueOffset, BlockBuilder output) {
        Double result = AbstractVarianceAggregation.buildFinalVariance(this.population, valueSlice, valueOffset);
        if (result == null) {
            output.appendNull();
        } else {
            output.append(result);
        }
    }
}

