/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.block.BlockBuilder;
import com.facebook.presto.block.BlockCursor;
import com.facebook.presto.operator.ChannelHash;
import com.facebook.presto.operator.PagesIndex;
import io.airlift.slice.Slice;

public class SourceHash {
    private final ChannelHash channelHash;
    private final PagesIndex pagesIndex;
    private final int channelCount;

    public SourceHash(ChannelHash channelHash, PagesIndex pagesIndex) {
        this.channelHash = channelHash;
        this.pagesIndex = pagesIndex;
        this.channelCount = pagesIndex.getTupleInfos().size();
    }

    public int getChannelCount() {
        return this.channelCount;
    }

    public void setProbeSlice(Slice slice) {
        this.channelHash.setLookupSlice(slice);
    }

    public int getJoinPosition(BlockCursor cursor) {
        return this.channelHash.get(cursor);
    }

    public int getNextJoinPosition(int joinPosition) {
        return this.channelHash.getNextPosition(joinPosition);
    }

    public void appendTupleTo(int channel, int position, BlockBuilder blockBuilder) {
        this.pagesIndex.appendTupleTo(channel, position, blockBuilder);
    }
}

