/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.block.BlockBuilder;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.Page;
import com.facebook.presto.operator.PageBuilder;
import com.facebook.presto.spi.ColumnType;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.tuple.TupleInfo;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.DataSize;
import java.io.Closeable;
import java.util.List;

public class RecordProjectOperator
implements Operator,
Closeable {
    private static final int ROWS_PER_REQUEST = 16384;
    private final OperatorContext operatorContext;
    private final RecordCursor cursor;
    private final List<TupleInfo> tupleInfos;
    private final PageBuilder pageBuilder;
    private boolean finishing;
    private long completedBytes;

    public RecordProjectOperator(OperatorContext operatorContext, RecordSet recordSet) {
        this(operatorContext, recordSet.getColumnTypes(), recordSet.cursor());
    }

    public RecordProjectOperator(OperatorContext operatorContext, List<ColumnType> columnTypes, RecordCursor cursor) {
        this.operatorContext = (OperatorContext)Preconditions.checkNotNull((Object)operatorContext, (Object)"operatorContext is null");
        this.cursor = (RecordCursor)Preconditions.checkNotNull((Object)cursor, (Object)"cursor is null");
        ImmutableList.Builder tupleInfos = ImmutableList.builder();
        for (ColumnType columnType : columnTypes) {
            tupleInfos.add((Object)new TupleInfo(TupleInfo.Type.fromColumnType(columnType)));
        }
        this.tupleInfos = tupleInfos.build();
        this.pageBuilder = new PageBuilder(this.getTupleInfos());
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    public RecordCursor getCursor() {
        return this.cursor;
    }

    @Override
    public List<TupleInfo> getTupleInfos() {
        return this.tupleInfos;
    }

    @Override
    public void finish() {
        this.close();
    }

    @Override
    public void close() {
        this.finishing = true;
        this.cursor.close();
    }

    @Override
    public boolean isFinished() {
        return this.finishing && this.pageBuilder.isEmpty();
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return NOT_BLOCKED;
    }

    @Override
    public boolean needsInput() {
        return false;
    }

    @Override
    public void addInput(Page page) {
        throw new UnsupportedOperationException(this.getClass().getName() + " can not take input");
    }

    @Override
    public Page getOutput() {
        if (!this.finishing) {
            int i;
            for (i = 0; i < 16384 && !this.pageBuilder.isFull(); ++i) {
                if (!this.cursor.advanceNextPosition()) {
                    this.finishing = true;
                    break;
                }
                block7: for (int column = 0; column < this.tupleInfos.size(); ++column) {
                    BlockBuilder output = this.pageBuilder.getBlockBuilder(column);
                    if (this.cursor.isNull(column)) {
                        output.appendNull();
                        continue;
                    }
                    TupleInfo.Type type = this.getTupleInfos().get(column).getTypes().get(0);
                    switch (type) {
                        case BOOLEAN: {
                            output.append(this.cursor.getBoolean(column));
                            continue block7;
                        }
                        case FIXED_INT_64: {
                            output.append(this.cursor.getLong(column));
                            continue block7;
                        }
                        case DOUBLE: {
                            output.append(this.cursor.getDouble(column));
                            continue block7;
                        }
                        case VARIABLE_BINARY: {
                            output.append(this.cursor.getString(column));
                            continue block7;
                        }
                        default: {
                            throw new AssertionError((Object)("unimplemented type: " + type));
                        }
                    }
                }
            }
            long bytesProcessed = this.cursor.getCompletedBytes() - this.completedBytes;
            this.operatorContext.recordGeneratedInput(new DataSize((double)bytesProcessed, DataSize.Unit.BYTE), i);
            this.completedBytes += bytesProcessed;
        }
        if (this.pageBuilder.isEmpty() || !this.finishing && !this.pageBuilder.isFull()) {
            return null;
        }
        Page page = this.pageBuilder.build();
        this.pageBuilder.reset();
        this.operatorContext.recordGeneratedInput(page.getDataSize(), page.getPositionCount());
        return page;
    }
}

