/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.block.Block;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import io.airlift.units.DataSize;
import java.util.Arrays;

public class Page {
    private final Block[] blocks;
    private final int positionCount;

    public Page(Block ... blocks) {
        this(blocks[0].getPositionCount(), blocks);
    }

    public Page(int positionCount, Block ... blocks) {
        Preconditions.checkNotNull((Object)blocks, (Object)"blocks is null");
        this.blocks = Arrays.copyOf(blocks, blocks.length);
        this.positionCount = positionCount;
    }

    public int getChannelCount() {
        return this.blocks.length;
    }

    public int getPositionCount() {
        return this.positionCount;
    }

    public DataSize getDataSize() {
        long dataSize = 0L;
        for (Block block : this.blocks) {
            dataSize += block.getDataSize().toBytes();
        }
        return new DataSize((double)dataSize, DataSize.Unit.BYTE);
    }

    public Block[] getBlocks() {
        return (Block[])this.blocks.clone();
    }

    public Block getBlock(int channel) {
        return this.blocks[channel];
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("positionCount", this.positionCount).add("channelCount", this.getChannelCount()).addValue((Object)("@" + Integer.toHexString(System.identityHashCode(this)))).toString();
    }
}

