/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.block.BlockBuilder;
import com.facebook.presto.block.uncompressed.UncompressedBlock;
import com.facebook.presto.metadata.ColumnFileHandle;
import com.facebook.presto.metadata.LocalStorageManager;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.MaterializedViewWriterResult;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.Page;
import com.facebook.presto.operator.SourceOperator;
import com.facebook.presto.operator.SourceOperatorFactory;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.Split;
import com.facebook.presto.split.NativeSplit;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.tuple.TupleInfo;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

public class MaterializedViewWriterOperator
implements SourceOperator {
    private final OperatorContext operatorContext;
    private final PlanNodeId sourceId;
    private final LocalStorageManager storageManager;
    private final String nodeIdentifier;
    private final List<ColumnHandle> columnHandles;
    private ColumnFileHandle columnFileHandle;
    private final AtomicReference<NativeSplit> input = new AtomicReference();
    private State state = State.RUNNING;
    private long rowCount;

    public MaterializedViewWriterOperator(OperatorContext operatorContext, PlanNodeId sourceId, LocalStorageManager storageManager, String nodeIdentifier, List<ColumnHandle> columnHandles) throws IOException {
        this.operatorContext = (OperatorContext)Preconditions.checkNotNull((Object)operatorContext, (Object)"operatorContext is null");
        this.sourceId = (PlanNodeId)Preconditions.checkNotNull((Object)sourceId, (Object)"sourceId is null");
        this.storageManager = (LocalStorageManager)Preconditions.checkNotNull((Object)storageManager, (Object)"storageManager is null");
        this.nodeIdentifier = (String)Preconditions.checkNotNull((Object)nodeIdentifier, (Object)"nodeIdentifier is null");
        this.columnHandles = ImmutableList.copyOf(columnHandles);
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public PlanNodeId getSourceId() {
        return this.sourceId;
    }

    @Override
    public void addSplit(Split split) {
        Preconditions.checkNotNull((Object)split, (Object)"split is null");
        Preconditions.checkState((boolean)(split instanceof NativeSplit), (Object)"Non-native split added!");
        Preconditions.checkState((this.input.get() == null ? 1 : 0) != 0, (String)"Shard Id %s was already set!", (Object[])new Object[]{this.input.get()});
        this.input.set((NativeSplit)split);
        Object splitInfo = split.getInfo();
        if (splitInfo != null) {
            this.operatorContext.setInfoSupplier((Supplier<Object>)Suppliers.ofInstance((Object)splitInfo));
        }
    }

    @Override
    public void noMoreSplits() {
        Preconditions.checkState((this.input.get() != null ? 1 : 0) != 0, (Object)"No shard id was set!");
    }

    @Override
    public List<TupleInfo> getTupleInfos() {
        return ImmutableList.of((Object)TupleInfo.SINGLE_LONG);
    }

    @Override
    public void finish() {
        if (this.state == State.RUNNING) {
            this.state = State.FINISHING;
        }
    }

    @Override
    public boolean isFinished() {
        return this.state == State.FINISHED;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return NOT_BLOCKED;
    }

    @Override
    public boolean needsInput() {
        return this.state == State.RUNNING;
    }

    @Override
    public void addInput(Page page) {
        Preconditions.checkNotNull((Object)page, (Object)"page is null");
        Preconditions.checkState((this.state == State.RUNNING ? 1 : 0) != 0, (Object)"Operator is finishing");
        if (this.columnFileHandle == null) {
            try {
                this.columnFileHandle = this.storageManager.createStagingFileHandles(this.input.get().getShardUuid(), this.columnHandles);
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        this.rowCount += (long)this.columnFileHandle.append(page);
    }

    @Override
    public Page getOutput() {
        if (this.state != State.FINISHING) {
            return null;
        }
        this.state = State.FINISHED;
        if (this.columnFileHandle != null) {
            try {
                this.storageManager.commit(this.columnFileHandle);
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
            this.operatorContext.addOutputItems(this.sourceId, (Set<?>)ImmutableSet.of((Object)new MaterializedViewWriterResult(this.input.get().getShardUuid(), this.nodeIdentifier)));
        }
        UncompressedBlock block = new BlockBuilder(TupleInfo.SINGLE_LONG).append(this.rowCount).build();
        return new Page(block);
    }

    private static enum State {
        RUNNING,
        FINISHING,
        FINISHED;

    }

    public static class MaterializedViewWriterOperatorFactory
    implements SourceOperatorFactory {
        private final int operatorId;
        private final PlanNodeId sourceId;
        private final LocalStorageManager storageManager;
        private final String nodeIdentifier;
        private final List<ColumnHandle> columnHandles;

        public MaterializedViewWriterOperatorFactory(int operatorId, PlanNodeId sourceId, LocalStorageManager storageManager, String nodeIdentifier, List<ColumnHandle> columnHandles) {
            this.operatorId = operatorId;
            this.sourceId = (PlanNodeId)Preconditions.checkNotNull((Object)sourceId, (Object)"sourceId is null");
            this.storageManager = (LocalStorageManager)Preconditions.checkNotNull((Object)storageManager, (Object)"storageManager is null");
            this.nodeIdentifier = (String)Preconditions.checkNotNull((Object)nodeIdentifier, (Object)"nodeIdentifier is null");
            this.columnHandles = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(columnHandles, (Object)"columnHandles is null")));
        }

        @Override
        public PlanNodeId getSourceId() {
            return this.sourceId;
        }

        @Override
        public List<TupleInfo> getTupleInfos() {
            return ImmutableList.of((Object)TupleInfo.SINGLE_LONG);
        }

        @Override
        public SourceOperator createOperator(DriverContext driverContext) {
            try {
                OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, MaterializedViewWriterOperator.class.getSimpleName());
                return new MaterializedViewWriterOperator(operatorContext, this.sourceId, this.storageManager, this.nodeIdentifier, this.columnHandles);
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        @Override
        public void close() {
        }
    }
}

