/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.InMemoryExchange;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.Page;
import com.facebook.presto.tuple.TupleInfo;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;

public class InMemoryExchangeSourceOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final InMemoryExchange exchange;

    public InMemoryExchangeSourceOperator(OperatorContext operatorContext, InMemoryExchange exchange) {
        this.operatorContext = (OperatorContext)Preconditions.checkNotNull((Object)operatorContext, (Object)"operatorContext is null");
        this.exchange = (InMemoryExchange)Preconditions.checkNotNull((Object)exchange, (Object)"exchange is null");
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<TupleInfo> getTupleInfos() {
        return this.exchange.getTupleInfos();
    }

    @Override
    public void finish() {
        this.exchange.finish();
    }

    @Override
    public boolean isFinished() {
        return this.exchange.isFinished();
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        ListenableFuture<?> blocked = this.exchange.waitForNotEmpty();
        if (blocked.isDone()) {
            return NOT_BLOCKED;
        }
        return blocked;
    }

    @Override
    public boolean needsInput() {
        return false;
    }

    @Override
    public void addInput(Page page) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Page getOutput() {
        Page page = this.exchange.removePage();
        if (page != null) {
            this.operatorContext.recordGeneratedInput(page.getDataSize(), page.getPositionCount());
        }
        return page;
    }

    public static class InMemoryExchangeSourceOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final InMemoryExchange inMemoryExchange;
        private boolean closed;

        public InMemoryExchangeSourceOperatorFactory(int operatorId, InMemoryExchange inMemoryExchange) {
            this.operatorId = operatorId;
            this.inMemoryExchange = inMemoryExchange;
        }

        @Override
        public List<TupleInfo> getTupleInfos() {
            return this.inMemoryExchange.getTupleInfos();
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, InMemoryExchangeSourceOperator.class.getSimpleName());
            return new InMemoryExchangeSourceOperator(operatorContext, this.inMemoryExchange);
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }
}

