/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.InMemoryExchangeSinkOperator;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.Page;
import com.facebook.presto.tuple.TupleInfo;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class InMemoryExchange {
    private final List<TupleInfo> tupleInfos;
    private final Queue<Page> buffer;
    private final List<SettableFuture<?>> blockedCallers = new ArrayList();
    private boolean finishing;
    private boolean noMoreSinkFactories;
    private int sinkFactories;
    private int sinks;

    public InMemoryExchange(List<TupleInfo> tupleInfos) {
        this.tupleInfos = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(tupleInfos, (Object)"tupleInfos is null")));
        this.buffer = new ConcurrentLinkedQueue<Page>();
    }

    public List<TupleInfo> getTupleInfos() {
        return this.tupleInfos;
    }

    public synchronized OperatorFactory createSinkFactory(int operatorId) {
        ++this.sinkFactories;
        return new InMemoryExchangeSinkOperatorFactory(operatorId);
    }

    private synchronized void addSink() {
        Preconditions.checkState((this.sinkFactories > 0 ? 1 : 0) != 0, (Object)"All sink factories already closed");
        ++this.sinks;
    }

    public synchronized void sinkFinished() {
        Preconditions.checkState((this.sinks != 0 ? 1 : 0) != 0, (Object)"All sinks are already complete");
        --this.sinks;
        this.updateState();
    }

    public synchronized void noMoreSinkFactories() {
        this.noMoreSinkFactories = true;
        this.updateState();
    }

    private synchronized void sinkFactoryClosed() {
        Preconditions.checkState((this.sinkFactories != 0 ? 1 : 0) != 0, (Object)"All sinks factories are already closed");
        --this.sinkFactories;
        this.updateState();
    }

    private void updateState() {
        if (this.noMoreSinkFactories && this.sinkFactories == 0 && this.sinks == 0) {
            this.finishing = true;
        }
    }

    public synchronized boolean isFinishing() {
        return this.finishing;
    }

    public synchronized void finish() {
        this.finishing = true;
        this.notifyBlockedCallers();
    }

    public synchronized boolean isFinished() {
        return this.finishing && this.buffer.isEmpty();
    }

    public synchronized void addPage(Page page) {
        if (this.finishing) {
            return;
        }
        this.buffer.add(page);
        this.notifyBlockedCallers();
    }

    private synchronized void notifyBlockedCallers() {
        for (SettableFuture<?> blockedCaller : this.blockedCallers) {
            blockedCaller.set(null);
        }
        this.blockedCallers.clear();
    }

    public synchronized ListenableFuture<?> waitForNotEmpty() {
        if (this.finishing || !this.buffer.isEmpty()) {
            return Operator.NOT_BLOCKED;
        }
        SettableFuture settableFuture = SettableFuture.create();
        this.blockedCallers.add(settableFuture);
        return settableFuture;
    }

    public synchronized Page removePage() {
        return this.buffer.poll();
    }

    private class InMemoryExchangeSinkOperatorFactory
    implements OperatorFactory {
        private final int operatorId;

        private InMemoryExchangeSinkOperatorFactory(int operatorId) {
            this.operatorId = operatorId;
        }

        @Override
        public List<TupleInfo> getTupleInfos() {
            return InMemoryExchange.this.tupleInfos;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, InMemoryExchangeSinkOperator.class.getSimpleName());
            InMemoryExchange.this.addSink();
            return new InMemoryExchangeSinkOperator(operatorContext, InMemoryExchange.this);
        }

        @Override
        public void close() {
            InMemoryExchange.this.sinkFactoryClosed();
        }
    }
}

