/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.ChannelHash;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.Page;
import com.facebook.presto.operator.PagesIndex;
import com.facebook.presto.operator.SourceHash;
import com.facebook.presto.tuple.TupleInfo;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Collection;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class HashBuilderOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final HashSupplier hashSupplier;
    private final int hashChannel;
    private final PagesIndex pagesIndex;
    private boolean finished;

    public HashBuilderOperator(OperatorContext operatorContext, HashSupplier hashSupplier, int hashChannel, int expectedPositions) {
        this.operatorContext = (OperatorContext)Preconditions.checkNotNull((Object)operatorContext, (Object)"operatorContext is null");
        this.hashSupplier = (HashSupplier)Preconditions.checkNotNull((Object)hashSupplier, (Object)"hashSupplier is null");
        this.hashChannel = hashChannel;
        this.pagesIndex = new PagesIndex(hashSupplier.getTupleInfos(), expectedPositions, operatorContext);
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<TupleInfo> getTupleInfos() {
        return this.hashSupplier.getTupleInfos();
    }

    @Override
    public void finish() {
        if (this.finished) {
            return;
        }
        ChannelHash channelHash = new ChannelHash(this.pagesIndex.getIndex(this.hashChannel), this.operatorContext);
        this.hashSupplier.setHash(channelHash, this.pagesIndex);
        this.finished = true;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return NOT_BLOCKED;
    }

    @Override
    public boolean needsInput() {
        return !this.finished;
    }

    @Override
    public void addInput(Page page) {
        Preconditions.checkNotNull((Object)page, (Object)"page is null");
        Preconditions.checkState((!this.isFinished() ? 1 : 0) != 0, (Object)"Operator is already finished");
        this.pagesIndex.addPage(page);
        this.operatorContext.recordGeneratedOutput(page.getDataSize(), page.getPositionCount());
    }

    @Override
    public Page getOutput() {
        return null;
    }

    public static class HashBuilderOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final HashSupplier hashSupplier;
        private final int hashChannel;
        private final int expectedPositions;
        private boolean closed;

        public HashBuilderOperatorFactory(int operatorId, List<TupleInfo> tupleInfos, int hashChannel, int expectedPositions) {
            this.operatorId = operatorId;
            this.hashSupplier = new HashSupplier((List)Preconditions.checkNotNull(tupleInfos, (Object)"tupleInfos is null"));
            Preconditions.checkArgument((hashChannel >= 0 ? 1 : 0) != 0, (Object)"hashChannel is negative");
            this.hashChannel = hashChannel;
            this.expectedPositions = (Integer)Preconditions.checkNotNull((Object)expectedPositions, (Object)"expectedPositions is null");
        }

        public HashSupplier getHashSupplier() {
            return this.hashSupplier;
        }

        @Override
        public List<TupleInfo> getTupleInfos() {
            return this.hashSupplier.tupleInfos;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, HashBuilderOperator.class.getSimpleName());
            return new HashBuilderOperator(operatorContext, this.hashSupplier, this.hashChannel, this.expectedPositions);
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }

    public static class HashSupplier {
        private final List<TupleInfo> tupleInfos;
        private final SettableFuture<HashData> hashFuture = SettableFuture.create();

        public HashSupplier(List<TupleInfo> tupleInfos) {
            this.tupleInfos = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(tupleInfos, (Object)"tupleInfos is null")));
        }

        public List<TupleInfo> getTupleInfos() {
            return this.tupleInfos;
        }

        public ListenableFuture<SourceHash> getSourceHash() {
            return Futures.transform(this.hashFuture, (Function)new Function<HashData, SourceHash>(){

                public SourceHash apply(HashData hashData) {
                    return new SourceHash(new ChannelHash(hashData.channelHash), hashData.pagesIndex);
                }
            });
        }

        void setHash(ChannelHash channelHash, PagesIndex pagesIndex) {
            HashData hashData = new HashData((ChannelHash)Preconditions.checkNotNull((Object)channelHash, (Object)"channelHash is null"), (PagesIndex)Preconditions.checkNotNull((Object)pagesIndex, (Object)"pagesIndex is null"));
            boolean wasSet = this.hashFuture.set((Object)hashData);
            Preconditions.checkState((boolean)wasSet, (Object)"Hash already set");
        }

        private static class HashData {
            private final ChannelHash channelHash;
            private final PagesIndex pagesIndex;

            private HashData(ChannelHash channelHash, PagesIndex pagesIndex) {
                this.channelHash = channelHash;
                this.pagesIndex = pagesIndex;
            }
        }
    }
}

