/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.ExchangeClient;
import com.facebook.presto.operator.ExchangeClientConfig;
import com.facebook.presto.operator.ForExchange;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import io.airlift.http.client.AsyncHttpClient;
import io.airlift.units.DataSize;
import java.util.concurrent.Executor;
import javax.inject.Inject;

public class ExchangeClientFactory
implements Supplier<ExchangeClient> {
    private final DataSize maxBufferedBytes;
    private final int concurrentRequestMultiplier;
    private final AsyncHttpClient httpClient;
    private final DataSize maxResponseSize;
    private final Executor executor;

    @Inject
    public ExchangeClientFactory(ExchangeClientConfig config, @ForExchange AsyncHttpClient httpClient, @ForExchange Executor executor) {
        this(config.getExchangeMaxBufferSize(), new DataSize(10.0, DataSize.Unit.MEGABYTE), config.getExchangeConcurrentRequestMultiplier(), httpClient, executor);
    }

    public ExchangeClientFactory(DataSize maxBufferedBytes, DataSize maxResponseSize, int concurrentRequestMultiplier, AsyncHttpClient httpClient, Executor executor) {
        this.maxBufferedBytes = (DataSize)Preconditions.checkNotNull((Object)maxBufferedBytes, (Object)"maxBufferedBytes is null");
        this.concurrentRequestMultiplier = concurrentRequestMultiplier;
        this.httpClient = (AsyncHttpClient)Preconditions.checkNotNull((Object)httpClient, (Object)"httpClient is null");
        this.maxResponseSize = (DataSize)Preconditions.checkNotNull((Object)maxResponseSize, (Object)"maxResponseSize is null");
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor, (Object)"executor is null");
        Preconditions.checkArgument((maxBufferedBytes.toBytes() > 0L ? 1 : 0) != 0, (String)"maxBufferSize must be at least 1 byte: %s", (Object[])new Object[]{maxBufferedBytes});
        Preconditions.checkArgument((maxResponseSize.toBytes() > 0L ? 1 : 0) != 0, (String)"maxResponseSize must be at least 1 byte: %s", (Object[])new Object[]{maxResponseSize});
        Preconditions.checkArgument((concurrentRequestMultiplier > 0 ? 1 : 0) != 0, (String)"concurrentRequestMultiplier must be at least 1: %s", (Object[])new Object[]{concurrentRequestMultiplier});
    }

    public ExchangeClient get() {
        return new ExchangeClient(this.maxBufferedBytes, this.maxResponseSize, this.concurrentRequestMultiplier, this.httpClient, this.executor);
    }
}

