/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.ScheduledSplit;
import com.facebook.presto.TaskSource;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.Page;
import com.facebook.presto.operator.SourceOperator;
import com.facebook.presto.spi.Split;
import com.facebook.presto.split.CollocatedSplit;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;

public class Driver {
    private static final Logger log = Logger.get(Driver.class);
    private final DriverContext driverContext;
    private final List<Operator> operators;
    private final Map<PlanNodeId, SourceOperator> sourceOperators;
    private final ConcurrentMap<PlanNodeId, TaskSource> sources = new ConcurrentHashMap<PlanNodeId, TaskSource>();

    public Driver(DriverContext driverContext, Operator firstOperator, Operator ... otherOperators) {
        this((DriverContext)Preconditions.checkNotNull((Object)driverContext, (Object)"driverContext is null"), (List<Operator>)ImmutableList.builder().add(Preconditions.checkNotNull((Object)firstOperator, (Object)"firstOperator is null")).add((Object[])Preconditions.checkNotNull((Object)otherOperators, (Object)"otherOperators is null")).build());
    }

    public Driver(DriverContext driverContext, List<Operator> operators) {
        this.driverContext = (DriverContext)Preconditions.checkNotNull((Object)driverContext, (Object)"driverContext is null");
        this.operators = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(operators, (Object)"operators is null")));
        Preconditions.checkArgument((!operators.isEmpty() ? 1 : 0) != 0, (Object)"There must be at least one operator");
        ImmutableMap.Builder sourceOperators = ImmutableMap.builder();
        for (Operator operator : operators) {
            if (!(operator instanceof SourceOperator)) continue;
            SourceOperator sourceOperator = (SourceOperator)operator;
            sourceOperators.put((Object)sourceOperator.getSourceId(), (Object)sourceOperator);
        }
        this.sourceOperators = sourceOperators.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        try {
            for (Operator operator : this.operators) {
                operator.finish();
            }
        }
        catch (Throwable throwable) {
            for (Operator operator : this.operators) {
                if (!(operator instanceof AutoCloseable)) continue;
                try {
                    ((AutoCloseable)((Object)operator)).close();
                }
                catch (Exception e) {
                    if (e instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    log.error((Throwable)e, "Error closing operator %s for task %s", new Object[]{operator.getOperatorContext().getOperatorId(), this.driverContext.getTaskId()});
                }
            }
            this.driverContext.finished();
            throw throwable;
        }
        for (Operator operator : this.operators) {
            if (!(operator instanceof AutoCloseable)) continue;
            try {
                ((AutoCloseable)((Object)operator)).close();
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                log.error((Throwable)e, "Error closing operator %s for task %s", new Object[]{operator.getOperatorContext().getOperatorId(), this.driverContext.getTaskId()});
            }
        }
        this.driverContext.finished();
    }

    public DriverContext getDriverContext() {
        return this.driverContext;
    }

    public Set<PlanNodeId> getSourceIds() {
        return this.sourceOperators.keySet();
    }

    public synchronized void updateSource(TaskSource source) {
        Sets.SetView newSplits;
        PlanNodeId sourceId = source.getPlanNodeId();
        if (!this.sourceOperators.containsKey(sourceId)) {
            return;
        }
        TaskSource currentSource = (TaskSource)this.sources.get(sourceId);
        if (currentSource == null) {
            newSplits = source.getSplits();
        } else {
            TaskSource newSource = currentSource.update(source);
            if (newSource == currentSource) {
                return;
            }
            newSplits = Sets.difference(newSource.getSplits(), currentSource.getSplits());
            this.sources.put(sourceId, newSource);
        }
        for (ScheduledSplit newSplit : newSplits) {
            this.addSplit(sourceId, newSplit.getSplit());
        }
        if (source.isNoMoreSplits()) {
            this.sourceOperators.get(sourceId).noMoreSplits();
        }
    }

    private synchronized void addSplit(PlanNodeId sourceId, Split split) {
        Preconditions.checkNotNull((Object)sourceId, (Object)"sourceId is null");
        Preconditions.checkNotNull((Object)split, (Object)"split is null");
        if (split instanceof CollocatedSplit) {
            CollocatedSplit collocatedSplit = (CollocatedSplit)split;
            for (Map.Entry<PlanNodeId, Split> entry : collocatedSplit.getSplits().entrySet()) {
                this.addSplit(entry.getKey(), entry.getValue());
            }
        } else {
            SourceOperator sourceOperator = this.sourceOperators.get(sourceId);
            if (sourceOperator != null) {
                sourceOperator.addSplit(split);
            }
        }
    }

    public synchronized boolean isFinished() {
        boolean finished;
        boolean bl = finished = this.driverContext.isDone() || this.operators.get(this.operators.size() - 1).isFinished();
        if (finished) {
            this.close();
        }
        return finished;
    }

    public synchronized ListenableFuture<?> process() {
        this.driverContext.start();
        try {
            for (int i = 0; i < this.operators.size() - 1 && !this.driverContext.isDone(); ++i) {
                Operator current = this.operators.get(i);
                ListenableFuture<?> blocked = current.isBlocked();
                if (!blocked.isDone()) {
                    current.getOperatorContext().recordBlocked(blocked);
                    return blocked;
                }
                Operator next = this.operators.get(i + 1);
                blocked = next.isBlocked();
                if (!blocked.isDone()) {
                    next.getOperatorContext().recordBlocked(blocked);
                    return blocked;
                }
                if (current.isFinished()) {
                    next.getOperatorContext().startIntervalTimer();
                    next.finish();
                    next.getOperatorContext().recordFinish();
                    continue;
                }
                if (!next.needsInput()) continue;
                current.getOperatorContext().startIntervalTimer();
                Page page = current.getOutput();
                current.getOperatorContext().recordGetOutput(page);
                if (page == null) continue;
                next.getOperatorContext().startIntervalTimer();
                next.addInput(page);
                next.getOperatorContext().recordAddInput(page);
            }
            return Operator.NOT_BLOCKED;
        }
        catch (Throwable t) {
            this.driverContext.failed(t);
            throw t;
        }
    }

    public ListenableFuture<?> processFor(Duration duration) {
        Preconditions.checkNotNull((Object)duration, (Object)"duration is null");
        Preconditions.checkState((!Thread.holdsLock(this) ? 1 : 0) != 0, (String)"Can not process for a duration while holding a lock on the %s", (Object[])new Object[]{this.getClass().getSimpleName()});
        long maxRuntime = duration.roundTo(TimeUnit.NANOSECONDS);
        long start = System.nanoTime();
        do {
            ListenableFuture<?> future;
            if ((future = this.process()).isDone()) continue;
            return future;
        } while (System.nanoTime() - start < maxRuntime && !this.isFinished());
        return Operator.NOT_BLOCKED;
    }
}

