/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.block.Block;
import com.facebook.presto.block.BlockBuilder;
import com.facebook.presto.block.BlockCursor;
import com.facebook.presto.operator.AggregationFunctionDefinition;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.Page;
import com.facebook.presto.operator.aggregation.AggregationFunction;
import com.facebook.presto.operator.aggregation.FixedWidthAggregationFunction;
import com.facebook.presto.operator.aggregation.VariableWidthAggregationFunction;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.tree.Input;
import com.facebook.presto.tuple.TupleInfo;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.List;

public class AggregationOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final List<TupleInfo> tupleInfos;
    private final List<Aggregator> aggregates;
    private State state = State.NEEDS_INPUT;

    public AggregationOperator(OperatorContext operatorContext, AggregationNode.Step step, List<AggregationFunctionDefinition> functionDefinitions) {
        this.operatorContext = (OperatorContext)Preconditions.checkNotNull((Object)operatorContext, (Object)"operatorContext is null");
        Preconditions.checkNotNull((Object)((Object)step), (Object)"step is null");
        Preconditions.checkNotNull(functionDefinitions, (Object)"functionDefinitions is null");
        this.tupleInfos = AggregationOperator.toTupleInfos(step, functionDefinitions);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (AggregationFunctionDefinition functionDefinition : functionDefinitions) {
            builder.add((Object)AggregationOperator.createAggregator(functionDefinition, step));
        }
        this.aggregates = builder.build();
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<TupleInfo> getTupleInfos() {
        return this.tupleInfos;
    }

    @Override
    public void finish() {
        if (this.state == State.NEEDS_INPUT) {
            this.state = State.HAS_OUTPUT;
        }
    }

    @Override
    public boolean isFinished() {
        return this.state == State.FINISHED;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return NOT_BLOCKED;
    }

    @Override
    public boolean needsInput() {
        return this.state == State.NEEDS_INPUT;
    }

    @Override
    public void addInput(Page page) {
        Preconditions.checkState((boolean)this.needsInput(), (Object)"Operator is already finishing");
        Preconditions.checkNotNull((Object)page, (Object)"page is null");
        for (Aggregator aggregate : this.aggregates) {
            aggregate.addValue(page);
        }
    }

    @Override
    public Page getOutput() {
        if (this.state != State.HAS_OUTPUT) {
            return null;
        }
        Block[] blocks = new Block[this.aggregates.size()];
        for (int i = 0; i < blocks.length; ++i) {
            blocks[i] = this.aggregates.get(i).getResult();
        }
        this.state = State.FINISHED;
        return new Page(blocks);
    }

    @VisibleForTesting
    public static Aggregator createAggregator(AggregationFunctionDefinition functionDefinition, AggregationNode.Step step) {
        AggregationFunction function = functionDefinition.getFunction();
        if (function instanceof VariableWidthAggregationFunction) {
            return new VariableWidthAggregator((VariableWidthAggregationFunction)functionDefinition.getFunction(), functionDefinition.getInputs(), step);
        }
        Input input = null;
        if (!functionDefinition.getInputs().isEmpty()) {
            input = (Input)Iterables.getOnlyElement(functionDefinition.getInputs());
        }
        return new FixedWidthAggregator((FixedWidthAggregationFunction)functionDefinition.getFunction(), input, step);
    }

    private static List<TupleInfo> toTupleInfos(AggregationNode.Step step, List<AggregationFunctionDefinition> functionDefinitions) {
        ImmutableList.Builder tupleInfos = ImmutableList.builder();
        for (AggregationFunctionDefinition functionDefinition : functionDefinitions) {
            if (step != AggregationNode.Step.PARTIAL) {
                tupleInfos.add((Object)functionDefinition.getFunction().getFinalTupleInfo());
                continue;
            }
            tupleInfos.add((Object)functionDefinition.getFunction().getIntermediateTupleInfo());
        }
        return tupleInfos.build();
    }

    private static class VariableWidthAggregator<T>
    implements Aggregator {
        private final VariableWidthAggregationFunction<T> function;
        private final List<Input> inputs;
        private final AggregationNode.Step step;
        private T intermediateValue;
        private final Block[] blocks;
        private final BlockCursor[] blockCursors;
        private final int[] fields;

        private VariableWidthAggregator(VariableWidthAggregationFunction<T> function, List<Input> inputs, AggregationNode.Step step) {
            Preconditions.checkNotNull(function, (Object)"function is null");
            Preconditions.checkNotNull((Object)((Object)step), (Object)"step is null");
            this.function = function;
            this.inputs = inputs;
            this.step = step;
            this.intermediateValue = function.initialize();
            this.blocks = new Block[inputs.size()];
            this.blockCursors = new BlockCursor[inputs.size()];
            this.fields = new int[inputs.size()];
            for (int i = 0; i < this.fields.length; ++i) {
                this.fields[i] = inputs.get(i).getField();
            }
        }

        @Override
        public void addValue(Page page) {
            if (this.step == AggregationNode.Step.FINAL) {
                for (int i = 0; i < this.blockCursors.length; ++i) {
                    this.blockCursors[i] = page.getBlock(this.inputs.get(i).getChannel()).cursor();
                }
                while (VariableWidthAggregator.advanceAll(this.blockCursors)) {
                    this.intermediateValue = this.function.addIntermediate(this.blockCursors, this.fields, this.intermediateValue);
                }
            } else {
                for (int i = 0; i < this.blocks.length; ++i) {
                    this.blocks[i] = page.getBlock(this.inputs.get(i).getChannel());
                }
                this.intermediateValue = this.function.addInput(page.getPositionCount(), this.blocks, this.fields, this.intermediateValue);
            }
        }

        @Override
        public void addValue(BlockCursor ... cursors) {
            for (int i = 0; i < this.blockCursors.length; ++i) {
                this.blockCursors[i] = cursors[this.inputs.get(i).getChannel()];
            }
            this.intermediateValue = this.step == AggregationNode.Step.FINAL ? this.function.addIntermediate(this.blockCursors, this.fields, this.intermediateValue) : this.function.addInput(this.blockCursors, this.fields, this.intermediateValue);
        }

        @Override
        public Block getResult() {
            if (this.step == AggregationNode.Step.PARTIAL) {
                BlockBuilder output = new BlockBuilder(this.function.getIntermediateTupleInfo());
                this.function.evaluateIntermediate(this.intermediateValue, output);
                return output.build();
            }
            BlockBuilder output = new BlockBuilder(this.function.getFinalTupleInfo());
            this.function.evaluateFinal(this.intermediateValue, output);
            return output.build();
        }

        private static boolean advanceAll(BlockCursor ... cursors) {
            boolean allAdvanced = true;
            for (BlockCursor cursor : cursors) {
                allAdvanced = cursor.advanceNextPosition() && allAdvanced;
            }
            return allAdvanced;
        }
    }

    private static class FixedWidthAggregator
    implements Aggregator {
        private final FixedWidthAggregationFunction function;
        private final Input input;
        private final AggregationNode.Step step;
        private final Slice intermediateValue;

        private FixedWidthAggregator(FixedWidthAggregationFunction function, Input input, AggregationNode.Step step) {
            Preconditions.checkNotNull((Object)function, (Object)"function is null");
            Preconditions.checkNotNull((Object)((Object)step), (Object)"step is null");
            this.function = function;
            this.input = input;
            this.step = step;
            this.intermediateValue = Slices.allocate((int)function.getFixedSize());
            function.initialize(this.intermediateValue, 0);
        }

        @Override
        public void addValue(BlockCursor ... cursors) {
            BlockCursor cursor = cursors[this.input.getChannel()];
            if (this.step == AggregationNode.Step.FINAL) {
                this.function.addIntermediate(cursor, this.input.getField(), this.intermediateValue, 0);
            } else {
                this.function.addInput(cursor, this.input.getField(), this.intermediateValue, 0);
            }
        }

        @Override
        public void addValue(Page page) {
            if (this.step == AggregationNode.Step.FINAL) {
                BlockCursor cursor = page.getBlock(this.input.getChannel()).cursor();
                while (cursor.advanceNextPosition()) {
                    this.function.addIntermediate(cursor, this.input.getField(), this.intermediateValue, 0);
                }
            } else {
                Block block;
                int field = -1;
                if (this.input != null) {
                    block = page.getBlock(this.input.getChannel());
                    field = this.input.getField();
                } else {
                    block = null;
                }
                this.function.addInput(page.getPositionCount(), block, field, this.intermediateValue, 0);
            }
        }

        @Override
        public Block getResult() {
            if (this.step == AggregationNode.Step.PARTIAL) {
                BlockBuilder output = new BlockBuilder(this.function.getIntermediateTupleInfo());
                this.function.evaluateIntermediate(this.intermediateValue, 0, output);
                return output.build();
            }
            BlockBuilder output = new BlockBuilder(this.function.getFinalTupleInfo());
            this.function.evaluateFinal(this.intermediateValue, 0, output);
            return output.build();
        }
    }

    @VisibleForTesting
    public static interface Aggregator {
        public void addValue(Page var1);

        public void addValue(BlockCursor ... var1);

        public Block getResult();
    }

    private static enum State {
        NEEDS_INPUT,
        HAS_OUTPUT,
        FINISHED;

    }

    public static class AggregationOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final AggregationNode.Step step;
        private final List<AggregationFunctionDefinition> functionDefinitions;
        private final List<TupleInfo> tupleInfos;
        private boolean closed;

        public AggregationOperatorFactory(int operatorId, AggregationNode.Step step, List<AggregationFunctionDefinition> functionDefinitions) {
            this.operatorId = operatorId;
            this.step = step;
            this.functionDefinitions = functionDefinitions;
            this.tupleInfos = AggregationOperator.toTupleInfos(step, functionDefinitions);
        }

        @Override
        public List<TupleInfo> getTupleInfos() {
            return this.tupleInfos;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, AggregationOperator.class.getSimpleName());
            return new AggregationOperator(operatorContext, this.step, this.functionDefinitions);
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }
}

