/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.spi.ColumnHandle;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;

public class NativeColumnHandle
implements ColumnHandle {
    private final String columnName;
    private final long columnId;

    @JsonCreator
    public NativeColumnHandle(@JsonProperty(value="columnName") String columnName, @JsonProperty(value="columnId") long columnId) {
        this.columnName = (String)Preconditions.checkNotNull((Object)columnName, (Object)"columnName is null");
        Preconditions.checkArgument((columnId > 0L ? 1 : 0) != 0, (Object)"columnId must be greater than zero");
        this.columnId = columnId;
    }

    @JsonProperty
    public String getColumnName() {
        return this.columnName;
    }

    @JsonProperty
    public long getColumnId() {
        return this.columnId;
    }

    public String toString() {
        return "native:" + this.columnName + ":" + this.columnId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NativeColumnHandle that = (NativeColumnHandle)o;
        return this.columnId == that.columnId;
    }

    public int hashCode() {
        return (int)(this.columnId ^ this.columnId >>> 32);
    }
}

