/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.connector.informationSchema.InformationSchemaMetadata;
import com.facebook.presto.metadata.FunctionHandle;
import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.metadata.QualifiedTableName;
import com.facebook.presto.metadata.QualifiedTablePrefix;
import com.facebook.presto.metadata.TableMetadata;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorMetadata;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.sql.analyzer.Type;
import com.facebook.presto.sql.tree.QualifiedName;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.inject.Singleton;

@Singleton
public class MetadataManager
implements Metadata {
    public static final String INTERNAL_CONNECTOR_ID = "$internal";
    private final CopyOnWriteArrayList<ConnectorMetadataEntry> internalSchemas = new CopyOnWriteArrayList();
    private final ConcurrentMap<String, ConnectorMetadataEntry> connectors = new ConcurrentHashMap<String, ConnectorMetadataEntry>();
    private final ConcurrentMap<String, ConnectorMetadataEntry> informationSchemas = new ConcurrentHashMap<String, ConnectorMetadataEntry>();
    private final FunctionRegistry functions = new FunctionRegistry();

    public void addConnectorMetadata(String connectorId, String catalogName, ConnectorMetadata connectorMetadata) {
        ConnectorMetadataEntry entry = new ConnectorMetadataEntry(connectorId, connectorMetadata);
        Preconditions.checkState((this.connectors.putIfAbsent(catalogName, entry) == null ? 1 : 0) != 0, (String)"Catalog '%s' is already registered", (Object[])new Object[]{catalogName});
        this.informationSchemas.put(catalogName, new ConnectorMetadataEntry(INTERNAL_CONNECTOR_ID, new InformationSchemaMetadata(catalogName)));
    }

    public void addInternalSchemaMetadata(String connectorId, ConnectorMetadata connectorMetadata) {
        Preconditions.checkNotNull((Object)connectorId, (Object)"connectorId is null");
        Preconditions.checkNotNull((Object)connectorMetadata, (Object)"connectorMetadata is null");
        this.internalSchemas.add(new ConnectorMetadataEntry(connectorId, connectorMetadata));
    }

    @Override
    public FunctionInfo getFunction(QualifiedName name, List<Type> parameterTypes) {
        return this.functions.get(name, parameterTypes);
    }

    @Override
    public FunctionInfo getFunction(FunctionHandle handle) {
        return this.functions.get(handle);
    }

    @Override
    public boolean isAggregationFunction(QualifiedName name) {
        return this.functions.isAggregationFunction(name);
    }

    @Override
    public List<FunctionInfo> listFunctions() {
        return this.functions.list();
    }

    @Override
    public List<String> listSchemaNames(String catalogName) {
        MetadataUtil.checkCatalogName(catalogName);
        ImmutableSet.Builder schemaNames = ImmutableSet.builder();
        for (ConnectorMetadataEntry entry : this.allConnectorsFor(catalogName)) {
            schemaNames.addAll((Iterable)entry.getMetadata().listSchemaNames());
        }
        return ImmutableList.copyOf((Collection)schemaNames.build());
    }

    @Override
    public Optional<TableHandle> getTableHandle(QualifiedTableName table) {
        Preconditions.checkNotNull((Object)table, (Object)"table is null");
        SchemaTableName tableName = table.asSchemaTableName();
        for (ConnectorMetadataEntry entry : this.allConnectorsFor(table.getCatalogName())) {
            TableHandle tableHandle = entry.getMetadata().getTableHandle(tableName);
            if (tableHandle == null) continue;
            return Optional.of((Object)tableHandle);
        }
        return Optional.absent();
    }

    @Override
    public TableMetadata getTableMetadata(TableHandle tableHandle) {
        ConnectorTableMetadata tableMetadata = this.lookupConnectorFor(tableHandle).getMetadata().getTableMetadata(tableHandle);
        return new TableMetadata(this.getConnectorId(tableHandle), tableMetadata);
    }

    @Override
    public Map<String, ColumnHandle> getColumnHandles(TableHandle tableHandle) {
        return this.lookupConnectorFor(tableHandle).getMetadata().getColumnHandles(tableHandle);
    }

    @Override
    public ColumnMetadata getColumnMetadata(TableHandle tableHandle, ColumnHandle columnHandle) {
        Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
        Preconditions.checkNotNull((Object)columnHandle, (Object)"columnHandle is null");
        return this.lookupConnectorFor(tableHandle).getMetadata().getColumnMetadata(tableHandle, columnHandle);
    }

    @Override
    public List<QualifiedTableName> listTables(QualifiedTablePrefix prefix) {
        Preconditions.checkNotNull((Object)prefix, (Object)"prefix is null");
        String schemaNameOrNull = (String)prefix.getSchemaName().orNull();
        LinkedHashSet<QualifiedTableName> tables = new LinkedHashSet<QualifiedTableName>();
        for (ConnectorMetadataEntry entry : this.allConnectorsFor(prefix.getCatalogName())) {
            for (QualifiedTableName tableName : Iterables.transform((Iterable)entry.getMetadata().listTables(schemaNameOrNull), QualifiedTableName.convertFromSchemaTableName(prefix.getCatalogName()))) {
                tables.add(tableName);
            }
        }
        return ImmutableList.copyOf(tables);
    }

    @Override
    public Optional<ColumnHandle> getColumnHandle(TableHandle tableHandle, String columnName) {
        Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
        MetadataUtil.checkColumnName(columnName);
        return Optional.fromNullable((Object)this.lookupConnectorFor(tableHandle).getMetadata().getColumnHandle(tableHandle, columnName));
    }

    @Override
    public Map<QualifiedTableName, List<ColumnMetadata>> listTableColumns(QualifiedTablePrefix prefix) {
        Preconditions.checkNotNull((Object)prefix, (Object)"prefix is null");
        LinkedHashMap tableColumns = new LinkedHashMap();
        for (ConnectorMetadataEntry connectorMetadata : this.allConnectorsFor(prefix.getCatalogName())) {
            for (Map.Entry entry : connectorMetadata.getMetadata().listTableColumns(prefix.asSchemaTablePrefix()).entrySet()) {
                QualifiedTableName tableName = new QualifiedTableName(prefix.getCatalogName(), ((SchemaTableName)entry.getKey()).getSchemaName(), ((SchemaTableName)entry.getKey()).getTableName());
                if (tableColumns.containsKey(tableName)) continue;
                tableColumns.put(tableName, entry.getValue());
            }
        }
        return ImmutableMap.copyOf(tableColumns);
    }

    @Override
    public TableHandle createTable(String catalogName, TableMetadata tableMetadata) {
        ConnectorMetadataEntry connectorMetadata = (ConnectorMetadataEntry)this.connectors.get(catalogName);
        Preconditions.checkArgument((connectorMetadata != null ? 1 : 0) != 0, (String)"Catalog %s does not exist", (Object[])new Object[]{catalogName});
        return connectorMetadata.getMetadata().createTable(tableMetadata.getMetadata());
    }

    @Override
    public void dropTable(TableHandle tableHandle) {
        this.lookupConnectorFor(tableHandle).getMetadata().dropTable(tableHandle);
    }

    @Override
    public String getConnectorId(TableHandle tableHandle) {
        return this.lookupConnectorFor(tableHandle).getConnectorId();
    }

    @Override
    public Optional<TableHandle> getTableHandle(String connectorId, SchemaTableName tableName) {
        ConnectorMetadataEntry entry = (ConnectorMetadataEntry)this.connectors.get(connectorId);
        if (entry == null) {
            return Optional.absent();
        }
        return Optional.fromNullable((Object)entry.getMetadata().getTableHandle(tableName));
    }

    @Override
    public Map<String, String> getCatalogNames() {
        ImmutableMap.Builder catalogsMap = ImmutableMap.builder();
        for (Map.Entry entry : this.connectors.entrySet()) {
            catalogsMap.put(entry.getKey(), (Object)((ConnectorMetadataEntry)entry.getValue()).getConnectorId());
        }
        return catalogsMap.build();
    }

    private List<ConnectorMetadataEntry> allConnectorsFor(String catalogName) {
        ConnectorMetadataEntry informationSchema;
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(this.internalSchemas);
        ConnectorMetadataEntry connector = (ConnectorMetadataEntry)this.connectors.get(catalogName);
        if (connector != null) {
            builder.add((Object)connector);
        }
        if ((informationSchema = (ConnectorMetadataEntry)this.informationSchemas.get(catalogName)) != null) {
            builder.add((Object)informationSchema);
        }
        return builder.build();
    }

    private ConnectorMetadataEntry lookupConnectorFor(TableHandle tableHandle) {
        Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
        for (Map.Entry entry : this.informationSchemas.entrySet()) {
            if (!((ConnectorMetadataEntry)entry.getValue()).getMetadata().canHandle(tableHandle)) continue;
            return (ConnectorMetadataEntry)entry.getValue();
        }
        for (ConnectorMetadataEntry connectorMetadataEntry : this.internalSchemas) {
            if (!connectorMetadataEntry.getMetadata().canHandle(tableHandle)) continue;
            return connectorMetadataEntry;
        }
        for (Map.Entry entry : this.connectors.entrySet()) {
            if (!((ConnectorMetadataEntry)entry.getValue()).getMetadata().canHandle(tableHandle)) continue;
            return (ConnectorMetadataEntry)entry.getValue();
        }
        throw new IllegalArgumentException("Table %s does not exist: " + tableHandle);
    }

    private static class ConnectorMetadataEntry {
        private final String connectorId;
        private final ConnectorMetadata metadata;

        private ConnectorMetadataEntry(String connectorId, ConnectorMetadata metadata) {
            Preconditions.checkNotNull((Object)connectorId, (Object)"connectorId is null");
            Preconditions.checkNotNull((Object)metadata, (Object)"metadata is null");
            this.connectorId = connectorId;
            this.metadata = metadata;
        }

        private String getConnectorId() {
            return this.connectorId;
        }

        private ConnectorMetadata getMetadata() {
            return this.metadata;
        }
    }
}

