/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.block.Block;
import com.facebook.presto.block.BlockIterable;
import com.facebook.presto.block.BlockIterables;
import com.facebook.presto.block.BlockUtils;
import com.facebook.presto.operator.Page;
import com.facebook.presto.operator.PageBuilder;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.tuple.Tuple;
import com.facebook.presto.tuple.TupleInfo;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class InternalTable {
    private final Map<String, BlockIterable> columns;

    public InternalTable(Map<String, BlockIterable> columns) {
        this.columns = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(columns, (Object)"columns is null")));
    }

    public Set<String> getColumnNames() {
        return this.columns.keySet();
    }

    public BlockIterable getColumn(String columnName) {
        return this.columns.get(columnName);
    }

    public List<BlockIterable> getColumns(List<String> columnNames) {
        ImmutableList.Builder columns = ImmutableList.builder();
        for (String columnName : columnNames) {
            columns.add((Object)this.getColumn(columnName));
        }
        return columns.build();
    }

    public static Builder builder(TupleInfo tupleInfo, String firstColumnName, String ... otherColumnNames) {
        return new Builder(tupleInfo, (List<String>)ImmutableList.builder().add((Object)firstColumnName).add((Object[])otherColumnNames).build());
    }

    public static Builder builder(TupleInfo tupleInfo, List<String> columnNames) {
        return new Builder(tupleInfo, columnNames);
    }

    public static Builder builder(List<ColumnMetadata> columns) {
        ImmutableList.Builder names = ImmutableList.builder();
        ImmutableList.Builder types = ImmutableList.builder();
        for (ColumnMetadata column : columns) {
            names.add((Object)column.getName());
            types.add((Object)TupleInfo.Type.fromColumnType(column.getType()));
        }
        return new Builder(new TupleInfo((List<TupleInfo.Type>)types.build()), (List<String>)names.build());
    }

    public static class Builder {
        private final TupleInfo tupleInfo;
        private final List<TupleInfo> tupleInfos;
        private final List<String> columnNames;
        private final List<List<Block>> columns;
        private PageBuilder pageBuilder;

        public Builder(TupleInfo tupleInfo, List<String> columnNames) {
            this.tupleInfo = (TupleInfo)Preconditions.checkNotNull((Object)tupleInfo, (Object)"tupleInfo is null");
            this.tupleInfos = Builder.getTupleInfos(tupleInfo);
            this.columnNames = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(columnNames, (Object)"columnNames is null")));
            Preconditions.checkArgument((columnNames.size() == tupleInfo.getFieldCount() ? 1 : 0) != 0, (String)"Column name count does not match tuple field count: columnNames=%s, tupleInfo=%s", (Object[])new Object[]{columnNames, tupleInfo});
            this.columns = new ArrayList<List<Block>>();
            for (int i = 0; i < tupleInfo.getFieldCount(); ++i) {
                this.columns.add(new ArrayList());
            }
            this.pageBuilder = new PageBuilder(this.tupleInfos);
        }

        public TupleInfo getTupleInfo() {
            return this.tupleInfo;
        }

        public Builder add(Tuple tuple) {
            Preconditions.checkArgument((boolean)tuple.getTupleInfo().equals(this.tupleInfo), (Object)"tuple schema does not match builder");
            for (int i = 0; i < this.tupleInfo.getFieldCount(); ++i) {
                this.pageBuilder.getBlockBuilder(i).append(tuple, i);
            }
            if (this.pageBuilder.isFull()) {
                this.flushPage();
                this.pageBuilder = new PageBuilder(this.tupleInfos);
            }
            return this;
        }

        public InternalTable build() {
            this.flushPage();
            ImmutableMap.Builder data = ImmutableMap.builder();
            for (int i = 0; i < this.columns.size(); ++i) {
                List<Block> column = this.columns.get(i);
                data.put((Object)this.columnNames.get(i), (Object)(column.isEmpty() ? BlockUtils.emptyBlockIterable() : BlockIterables.createBlockIterable(column)));
            }
            return new InternalTable((Map<String, BlockIterable>)data.build());
        }

        private void flushPage() {
            if (!this.pageBuilder.isEmpty()) {
                Page page = this.pageBuilder.build();
                for (int i = 0; i < this.tupleInfo.getFieldCount(); ++i) {
                    this.columns.get(i).add(page.getBlock(i));
                }
            }
        }

        private static List<TupleInfo> getTupleInfos(TupleInfo tupleInfo) {
            ImmutableList.Builder list = ImmutableList.builder();
            for (TupleInfo.Type type : tupleInfo.getTypes()) {
                list.add((Object)new TupleInfo(type));
            }
            return list.build();
        }
    }
}

