/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorMetadata;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.tpch.TpchColumnHandle;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class InMemoryMetadata
implements ConnectorMetadata {
    private final ConcurrentMap<SchemaTableName, ConnectorTableMetadata> tables = new ConcurrentHashMap<SchemaTableName, ConnectorTableMetadata>();

    public boolean canHandle(TableHandle tableHandle) {
        return tableHandle instanceof InMemoryTableHandle;
    }

    public List<String> listSchemaNames() {
        HashSet<String> schemaNames = new HashSet<String>();
        for (SchemaTableName schemaTableName : this.tables.keySet()) {
            schemaNames.add(schemaTableName.getSchemaName());
        }
        return ImmutableList.copyOf(schemaNames);
    }

    public TableHandle getTableHandle(SchemaTableName tableName) {
        Preconditions.checkNotNull((Object)tableName, (Object)"tableName is null");
        if (!this.tables.containsKey(tableName)) {
            return null;
        }
        return new InMemoryTableHandle(tableName);
    }

    public ConnectorTableMetadata getTableMetadata(TableHandle tableHandle) {
        Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
        SchemaTableName tableName = this.getTableName(tableHandle);
        ConnectorTableMetadata tableMetadata = (ConnectorTableMetadata)this.tables.get(tableName);
        Preconditions.checkArgument((tableMetadata != null ? 1 : 0) != 0, (String)"Table %s does not exist", (Object[])new Object[]{tableName});
        return tableMetadata;
    }

    public Map<String, ColumnHandle> getColumnHandles(TableHandle tableHandle) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ColumnMetadata columnMetadata : this.getTableMetadata(tableHandle).getColumns()) {
            builder.put((Object)columnMetadata.getName(), (Object)new TpchColumnHandle(columnMetadata.getName(), columnMetadata.getOrdinalPosition(), columnMetadata.getType()));
        }
        return builder.build();
    }

    public ColumnHandle getColumnHandle(TableHandle tableHandle, String columnName) {
        for (ColumnMetadata columnMetadata : this.getTableMetadata(tableHandle).getColumns()) {
            if (!columnMetadata.getName().equals(columnName)) continue;
            return new TpchColumnHandle(columnMetadata.getName(), columnMetadata.getOrdinalPosition(), columnMetadata.getType());
        }
        return null;
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(SchemaTablePrefix prefix) {
        Preconditions.checkNotNull((Object)prefix, (Object)"prefix is null");
        ImmutableMap.Builder tableColumns = ImmutableMap.builder();
        for (SchemaTableName tableName : this.listTables(prefix.getSchemaName())) {
            int position = 1;
            ImmutableList.Builder columns = ImmutableList.builder();
            for (ColumnMetadata column : ((ConnectorTableMetadata)this.tables.get(tableName)).getColumns()) {
                columns.add((Object)new ColumnMetadata(column.getName(), column.getType(), position, false));
                ++position;
            }
            tableColumns.put((Object)tableName, (Object)columns.build());
        }
        return tableColumns.build();
    }

    public ColumnMetadata getColumnMetadata(TableHandle tableHandle, ColumnHandle columnHandle) {
        SchemaTableName tableName = this.getTableName(tableHandle);
        Preconditions.checkArgument((boolean)(columnHandle instanceof TpchColumnHandle), (Object)"columnHandle is not an instance of TpchColumnHandle");
        TpchColumnHandle tpchColumnHandle = (TpchColumnHandle)columnHandle;
        int columnIndex = tpchColumnHandle.getFieldIndex();
        return (ColumnMetadata)((ConnectorTableMetadata)this.tables.get(tableName)).getColumns().get(columnIndex);
    }

    public List<SchemaTableName> listTables(String schemaNameOrNull) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (SchemaTableName tableName : this.tables.keySet()) {
            if (schemaNameOrNull != null && !schemaNameOrNull.equals(tableName.getSchemaName())) continue;
            builder.add((Object)tableName);
        }
        return builder.build();
    }

    public TableHandle createTable(ConnectorTableMetadata tableMetadata) {
        ConnectorTableMetadata existingTable = this.tables.putIfAbsent(tableMetadata.getTable(), tableMetadata);
        Preconditions.checkArgument((existingTable == null ? 1 : 0) != 0, (String)"Table %s already exists", (Object[])new Object[]{tableMetadata.getTable()});
        return new InMemoryTableHandle(tableMetadata.getTable());
    }

    public void dropTable(TableHandle tableHandle) {
        this.tables.remove(this.getTableName(tableHandle));
    }

    private SchemaTableName getTableName(TableHandle tableHandle) {
        Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
        Preconditions.checkArgument((boolean)(tableHandle instanceof InMemoryTableHandle), (Object)"tableHandle is not an instance of InMemoryTableHandle");
        InMemoryTableHandle inMemoryTableHandle = (InMemoryTableHandle)tableHandle;
        return inMemoryTableHandle.getTableName();
    }

    public static class InMemoryTableHandle
    implements TableHandle {
        private final SchemaTableName tableName;

        public InMemoryTableHandle(SchemaTableName schemaTableName) {
            this.tableName = schemaTableName;
        }

        public SchemaTableName getTableName() {
            return this.tableName;
        }
    }
}

