/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.Split;
import com.facebook.presto.spi.TableHandle;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;

public class HandleResolver {
    private final ConcurrentMap<String, ConnectorHandleResolver> handleIdResolvers = new ConcurrentHashMap<String, ConnectorHandleResolver>();

    public HandleResolver() {
    }

    @Inject
    public HandleResolver(Map<String, ConnectorHandleResolver> handleIdResolvers) {
        this.handleIdResolvers.putAll(handleIdResolvers);
    }

    public void addHandleResolver(String id, ConnectorHandleResolver connectorHandleResolver) {
        ConnectorHandleResolver existingResolver = this.handleIdResolvers.putIfAbsent(id, connectorHandleResolver);
        Preconditions.checkState((existingResolver == null ? 1 : 0) != 0, (String)"Id %s is already assigned to resolver %s", (Object[])new Object[]{id, existingResolver});
    }

    public String getId(TableHandle tableHandle) {
        for (Map.Entry entry : this.handleIdResolvers.entrySet()) {
            if (!((ConnectorHandleResolver)entry.getValue()).canHandle(tableHandle)) continue;
            return (String)entry.getKey();
        }
        throw new IllegalArgumentException("No connector for table handle: " + tableHandle);
    }

    public String getId(ColumnHandle columnHandle) {
        for (Map.Entry entry : this.handleIdResolvers.entrySet()) {
            if (!((ConnectorHandleResolver)entry.getValue()).canHandle(columnHandle)) continue;
            return (String)entry.getKey();
        }
        throw new IllegalArgumentException("No connector for column handle: " + columnHandle);
    }

    public String getId(Split split) {
        for (Map.Entry entry : this.handleIdResolvers.entrySet()) {
            if (!((ConnectorHandleResolver)entry.getValue()).canHandle(split)) continue;
            return (String)entry.getKey();
        }
        throw new IllegalArgumentException("No connector for split: " + split);
    }

    public Class<? extends TableHandle> getTableHandleClass(String id) {
        ConnectorHandleResolver connectorHandleResolver = (ConnectorHandleResolver)this.handleIdResolvers.get(id);
        Preconditions.checkArgument((connectorHandleResolver != null ? 1 : 0) != 0, (String)"No handle resolver for %s", (Object[])new Object[]{id});
        return connectorHandleResolver.getTableHandleClass();
    }

    public Class<? extends ColumnHandle> getColumnHandleClass(String id) {
        ConnectorHandleResolver connectorHandleResolver = (ConnectorHandleResolver)this.handleIdResolvers.get(id);
        Preconditions.checkArgument((connectorHandleResolver != null ? 1 : 0) != 0, (String)"No handle resolver for %s", (Object[])new Object[]{id});
        return connectorHandleResolver.getColumnHandleClass();
    }

    public Class<? extends Split> getSplitClass(String id) {
        ConnectorHandleResolver connectorHandleResolver = (ConnectorHandleResolver)this.handleIdResolvers.get(id);
        Preconditions.checkArgument((connectorHandleResolver != null ? 1 : 0) != 0, (String)"No handle resolver for %s", (Object[])new Object[]{id});
        return connectorHandleResolver.getSplitClass();
    }
}

