/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.metadata.FunctionHandle;
import com.facebook.presto.operator.AggregationFunctionDefinition;
import com.facebook.presto.operator.aggregation.AggregationFunction;
import com.facebook.presto.operator.window.WindowFunction;
import com.facebook.presto.sql.analyzer.Type;
import com.facebook.presto.sql.gen.FunctionBinder;
import com.facebook.presto.sql.tree.Input;
import com.facebook.presto.sql.tree.QualifiedName;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Ordering;
import java.lang.invoke.MethodHandle;
import java.util.Comparator;
import java.util.List;

public class FunctionInfo
implements Comparable<FunctionInfo> {
    private final int id;
    private final QualifiedName name;
    private final String description;
    private final Type returnType;
    private final List<Type> argumentTypes;
    private final boolean isAggregate;
    private final Type intermediateType;
    private final AggregationFunction aggregationFunction;
    private final MethodHandle scalarFunction;
    private final boolean deterministic;
    private final FunctionBinder functionBinder;
    private final boolean isWindow;
    private final Supplier<WindowFunction> windowFunction;

    public FunctionInfo(int id, QualifiedName name, String description, Type returnType, List<Type> argumentTypes, Supplier<WindowFunction> windowFunction) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.returnType = returnType;
        this.argumentTypes = argumentTypes;
        this.deterministic = true;
        this.isAggregate = false;
        this.intermediateType = null;
        this.aggregationFunction = null;
        this.scalarFunction = null;
        this.functionBinder = null;
        this.isWindow = true;
        this.windowFunction = (Supplier)Preconditions.checkNotNull(windowFunction, (Object)"windowFunction is null");
    }

    public FunctionInfo(int id, QualifiedName name, String description, Type returnType, List<Type> argumentTypes, Type intermediateType, AggregationFunction function) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.returnType = returnType;
        this.argumentTypes = argumentTypes;
        this.intermediateType = intermediateType;
        this.aggregationFunction = function;
        this.isAggregate = true;
        this.scalarFunction = null;
        this.deterministic = true;
        this.functionBinder = null;
        this.isWindow = false;
        this.windowFunction = null;
    }

    public FunctionInfo(int id, QualifiedName name, String description, Type returnType, List<Type> argumentTypes, MethodHandle function, boolean deterministic, FunctionBinder functionBinder) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.returnType = returnType;
        this.argumentTypes = argumentTypes;
        this.deterministic = deterministic;
        this.functionBinder = functionBinder;
        this.isAggregate = false;
        this.intermediateType = null;
        this.aggregationFunction = null;
        this.isWindow = false;
        this.windowFunction = null;
        this.scalarFunction = (MethodHandle)Preconditions.checkNotNull((Object)function, (Object)"function is null");
    }

    public FunctionHandle getHandle() {
        return new FunctionHandle(this.id, this.name.toString());
    }

    public QualifiedName getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isAggregate() {
        return this.isAggregate;
    }

    public boolean isWindow() {
        return this.isWindow;
    }

    public Supplier<WindowFunction> getWindowFunction() {
        Preconditions.checkState((boolean)this.isWindow, (Object)"not a window function");
        return this.windowFunction;
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public List<Type> getArgumentTypes() {
        return this.argumentTypes;
    }

    public Type getIntermediateType() {
        return this.intermediateType;
    }

    public AggregationFunctionDefinition bind(List<Input> inputs) {
        Preconditions.checkState((boolean)this.isAggregate, (Object)"function is not an aggregate");
        return AggregationFunctionDefinition.aggregation(this.aggregationFunction, inputs);
    }

    public MethodHandle getScalarFunction() {
        Preconditions.checkState((this.scalarFunction != null ? 1 : 0) != 0, (Object)"not a scalar function");
        return this.scalarFunction;
    }

    public boolean isDeterministic() {
        return this.deterministic;
    }

    public FunctionBinder getFunctionBinder() {
        return this.functionBinder;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FunctionInfo o = (FunctionInfo)obj;
        return Objects.equal((Object)this.isWindow, (Object)o.isWindow) && Objects.equal((Object)this.isAggregate, (Object)o.isAggregate) && Objects.equal((Object)this.name, (Object)o.name) && Objects.equal(this.argumentTypes, o.argumentTypes) && Objects.equal((Object)((Object)this.returnType), (Object)((Object)o.returnType));
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.isWindow, this.isAggregate, this.name, this.argumentTypes, this.returnType});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("isAggregate", this.isAggregate).add("isWindow", this.isWindow).add("name", (Object)this.name).add("argumentTypes", this.argumentTypes).add("returnType", (Object)this.returnType).toString();
    }

    @Override
    public int compareTo(FunctionInfo o) {
        return ComparisonChain.start().compareTrueFirst(this.isWindow, o.isWindow).compareTrueFirst(this.isAggregate, o.isAggregate).compare((Comparable)((Object)this.name.toString()), (Comparable)((Object)o.name.toString())).compare(this.argumentTypes, o.argumentTypes, (Comparator)Ordering.natural().lexicographical()).compare((Comparable)((Object)this.returnType), (Comparable)((Object)o.returnType)).result();
    }

    public static Function<FunctionInfo, QualifiedName> nameGetter() {
        return new Function<FunctionInfo, QualifiedName>(){

            public QualifiedName apply(FunctionInfo input) {
                return input.getName();
            }
        };
    }

    public static Function<FunctionInfo, FunctionHandle> handleGetter() {
        return new Function<FunctionInfo, FunctionHandle>(){

            public FunctionHandle apply(FunctionInfo input) {
                return input.getHandle();
            }
        };
    }

    public static Predicate<FunctionInfo> isAggregationPredicate() {
        return new Predicate<FunctionInfo>(){

            public boolean apply(FunctionInfo functionInfo) {
                return functionInfo.isAggregate();
            }
        };
    }
}

