/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.block.Block;
import com.facebook.presto.block.BlockIterable;
import com.facebook.presto.block.BlockUtils;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.metadata.ColumnFileHandle;
import com.facebook.presto.metadata.DatabaseLocalStorageManagerConfig;
import com.facebook.presto.metadata.ForLocalStorageManager;
import com.facebook.presto.metadata.LocalStorageManager;
import com.facebook.presto.metadata.NativeColumnHandle;
import com.facebook.presto.metadata.StorageManagerDao;
import com.facebook.presto.operator.AlignmentOperator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.Page;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.serde.BlocksFileEncoding;
import com.facebook.presto.serde.BlocksFileReader;
import com.facebook.presto.serde.BlocksFileStats;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.sql.analyzer.Session;
import com.facebook.presto.util.KeyBoundedExecutor;
import com.facebook.presto.util.Threads;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import io.airlift.concurrent.ThreadPoolExecutorMBean;
import io.airlift.log.Logger;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import javax.annotation.PreDestroy;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.IDBI;
import org.skife.jdbi.v2.TransactionCallback;
import org.skife.jdbi.v2.TransactionStatus;
import org.skife.jdbi.v2.VoidTransactionCallback;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class DatabaseLocalStorageManager
implements LocalStorageManager {
    private static final boolean ENABLE_OPTIMIZATION = Boolean.valueOf("false");
    private static final BlocksFileEncoding DEFAULT_ENCODING = BlocksFileEncoding.SNAPPY;
    private static final int RUN_LENGTH_AVERAGE_CUTOFF = 3;
    private static final int DICTIONARY_CARDINALITY_CUTOFF = 1000;
    private static final Logger log = Logger.get(DatabaseLocalStorageManager.class);
    private final ExecutorService executor;
    private final ThreadPoolExecutorMBean executorMBean;
    private final KeyBoundedExecutor<UUID> shardBoundedExecutor;
    private final IDBI dbi;
    private final File baseStorageDir;
    private final File baseStagingDir;
    private final StorageManagerDao dao;
    private final LoadingCache<File, Slice> mappedFileCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<File, Slice>(){

        public Slice load(File file) throws Exception {
            Preconditions.checkArgument((boolean)file.isAbsolute(), (Object)"file is not absolute");
            if (file.exists() && file.length() > 0L) {
                return Slices.mapFileReadOnly((File)file);
            }
            return Slices.EMPTY_SLICE;
        }
    });

    @Inject
    public DatabaseLocalStorageManager(@ForLocalStorageManager IDBI dbi, DatabaseLocalStorageManagerConfig config) throws IOException {
        Preconditions.checkNotNull((Object)config, (Object)"config is null");
        File baseDataDir = (File)Preconditions.checkNotNull((Object)config.getDataDirectory(), (Object)"dataDirectory is null");
        this.baseStorageDir = DatabaseLocalStorageManager.createDirectory(new File(baseDataDir, "storage"));
        this.baseStagingDir = DatabaseLocalStorageManager.createDirectory(new File(baseDataDir, "staging"));
        this.dbi = (IDBI)Preconditions.checkNotNull((Object)dbi, (Object)"dbi is null");
        this.dao = (StorageManagerDao)dbi.onDemand(StorageManagerDao.class);
        this.executor = Executors.newFixedThreadPool(config.getTasksPerNode(), Threads.threadsNamed("local-storage-manager-%s"));
        this.executorMBean = new ThreadPoolExecutorMBean((ThreadPoolExecutor)this.executor);
        this.shardBoundedExecutor = new KeyBoundedExecutor(this.executor);
        this.dao.createTableColumns();
    }

    @PreDestroy
    public void stop() {
        this.executor.shutdown();
    }

    @Managed
    @Nested
    public ThreadPoolExecutorMBean getExecutor() {
        return this.executorMBean;
    }

    @Override
    public ColumnFileHandle createStagingFileHandles(UUID shardUuid, List<? extends ColumnHandle> columnHandles) throws IOException {
        File shardPath = DatabaseLocalStorageManager.getShardPath(this.baseStagingDir, shardUuid);
        ColumnFileHandle.Builder builder = ColumnFileHandle.builder(shardUuid);
        for (ColumnHandle columnHandle : columnHandles) {
            File file = DatabaseLocalStorageManager.getColumnFile(shardPath, columnHandle, DEFAULT_ENCODING);
            com.google.common.io.Files.createParentDirs((File)file);
            builder.addColumn(columnHandle, file, DEFAULT_ENCODING);
        }
        return builder.build();
    }

    @Override
    public void commit(ColumnFileHandle columnFileHandle) throws IOException {
        Preconditions.checkNotNull((Object)columnFileHandle, (Object)"columnFileHandle is null");
        columnFileHandle.commit();
        ColumnFileHandle finalColumnFileHandle = this.optimizeEncodings(columnFileHandle);
        this.commitShardColumns(finalColumnFileHandle);
        this.deleteStagingDirectory(columnFileHandle);
    }

    private ColumnFileHandle optimizeEncodings(ColumnFileHandle columnFileHandle) throws IOException {
        UUID shardUuid = columnFileHandle.getShardUuid();
        File shardPath = DatabaseLocalStorageManager.getShardPath(this.baseStorageDir, shardUuid);
        ImmutableList.Builder sourcesBuilder = ImmutableList.builder();
        ColumnFileHandle.Builder builder = ColumnFileHandle.builder(shardUuid);
        for (Map.Entry<ColumnHandle, File> entry : columnFileHandle.getFiles().entrySet()) {
            File file = entry.getValue();
            ColumnHandle columnHandle = entry.getKey();
            if (file.exists()) {
                Slice slice = (Slice)this.mappedFileCache.getUnchecked((Object)file.getAbsoluteFile());
                Preconditions.checkState((file.length() == (long)slice.length() ? 1 : 0) != 0, (String)"File %s, length %s was mapped to Slice length %s", (Object[])new Object[]{file.getAbsolutePath(), file.length(), slice.length()});
                BlocksFileReader blocks = BlocksFileReader.readBlocks(slice);
                BlocksFileStats stats = blocks.getStats();
                boolean rleEncode = stats.getAvgRunLength() > 3L;
                boolean dicEncode = stats.getUniqueCount() < 1000;
                BlocksFileEncoding encoding = DEFAULT_ENCODING;
                if (ENABLE_OPTIMIZATION) {
                    if (dicEncode && rleEncode) {
                        encoding = BlocksFileEncoding.DIC_RLE;
                    } else if (dicEncode) {
                        encoding = BlocksFileEncoding.DIC_RAW;
                    } else if (rleEncode) {
                        encoding = BlocksFileEncoding.RLE;
                    }
                }
                File outputFile = DatabaseLocalStorageManager.getColumnFile(shardPath, columnHandle, encoding);
                com.google.common.io.Files.createParentDirs((File)outputFile);
                if (encoding == DEFAULT_ENCODING) {
                    com.google.common.io.Files.move((File)file, (File)outputFile);
                    builder.addColumn(columnHandle, outputFile);
                    continue;
                }
                sourcesBuilder.add((Object)blocks);
                builder.addColumn(columnHandle, outputFile, encoding);
                continue;
            }
            File outputFile = DatabaseLocalStorageManager.getColumnFile(shardPath, columnHandle, DEFAULT_ENCODING);
            builder.addColumn(columnHandle, outputFile);
        }
        ImmutableList sources = sourcesBuilder.build();
        ColumnFileHandle targetFileHandle = builder.build();
        if (!sources.isEmpty()) {
            Session session = new Session("user", "source", "catalog", "schema", "address", "agent");
            OperatorContext operatorContext = new TaskContext(new TaskId("query", "stage", "task"), this.executor, session).addPipelineContext(true, true).addDriverContext().addOperatorContext(0, "OptimizeEncodings");
            AlignmentOperator source = new AlignmentOperator(operatorContext, (Iterable<BlockIterable>)sources);
            DatabaseLocalStorageManager.importData(source, targetFileHandle);
        }
        targetFileHandle.commit();
        return targetFileHandle;
    }

    private void deleteStagingDirectory(ColumnFileHandle columnFileHandle) {
        File path = DatabaseLocalStorageManager.getShardPath(this.baseStagingDir, columnFileHandle.getShardUuid());
        while (path.delete() && !path.getParentFile().equals(this.baseStagingDir)) {
            path = path.getParentFile();
        }
    }

    private static void importData(AlignmentOperator source, ColumnFileHandle fileHandle) {
        while (!source.isFinished()) {
            Page page = source.getOutput();
            if (page != null) {
                fileHandle.append(page);
            }
            Preconditions.checkState((boolean)source.isBlocked().isDone(), (Object)"Alignment operator is blocked");
        }
    }

    @VisibleForTesting
    static File getShardPath(File baseDir, UUID shardUuid) {
        String uuid = shardUuid.toString().toLowerCase();
        return baseDir.toPath().resolve(uuid.substring(0, 2)).resolve(uuid.substring(2, 4)).resolve(uuid.substring(4, 6)).resolve(uuid).toFile();
    }

    private static File getColumnFile(File shardPath, ColumnHandle columnHandle, BlocksFileEncoding encoding) {
        Preconditions.checkState((boolean)(columnHandle instanceof NativeColumnHandle), (Object)"Can only import in a native column");
        long columnId = ((NativeColumnHandle)columnHandle).getColumnId();
        return new File(shardPath, String.format("%s.%s.column", columnId, encoding.getName()));
    }

    private void commitShardColumns(final ColumnFileHandle columnFileHandle) {
        this.dbi.inTransaction((TransactionCallback)new VoidTransactionCallback(){

            protected void execute(Handle handle, TransactionStatus status) throws Exception {
                StorageManagerDao dao = (StorageManagerDao)handle.attach(StorageManagerDao.class);
                for (Map.Entry<ColumnHandle, File> entry : columnFileHandle.getFiles().entrySet()) {
                    ColumnHandle columnHandle = entry.getKey();
                    File file = entry.getValue();
                    Preconditions.checkState((boolean)(columnHandle instanceof NativeColumnHandle), (Object)"Can only import in a native column");
                    long columnId = ((NativeColumnHandle)columnHandle).getColumnId();
                    String filename = file.getName();
                    dao.insertColumn(columnFileHandle.getShardUuid(), columnId, filename);
                }
            }
        });
    }

    @Override
    public BlockIterable getBlocks(UUID shardUuid, ColumnHandle columnHandle) {
        Preconditions.checkNotNull((Object)columnHandle);
        Preconditions.checkState((boolean)(columnHandle instanceof NativeColumnHandle), (Object)"Can only load blocks from a native column");
        long columnId = ((NativeColumnHandle)columnHandle).getColumnId();
        Preconditions.checkState((boolean)this.shardExists(shardUuid), (String)"shard %s does not exist in local database", (Object[])new Object[]{shardUuid});
        String filename = this.dao.getColumnFilename(shardUuid, columnId);
        File file = new File(DatabaseLocalStorageManager.getShardPath(this.baseStorageDir, shardUuid), filename);
        if (!file.exists()) {
            return BlockUtils.emptyBlockIterable();
        }
        return this.convertFilesToBlocks((Iterable<File>)ImmutableList.of((Object)file));
    }

    private BlockIterable convertFilesToBlocks(Iterable<File> files) {
        Preconditions.checkArgument((boolean)files.iterator().hasNext(), (Object)"no files in stream");
        Iterable blocks = Iterables.concat((Iterable)Iterables.transform(files, (Function)new Function<File, Iterable<? extends Block>>(){

            public Iterable<? extends Block> apply(File file) {
                Slice slice = (Slice)DatabaseLocalStorageManager.this.mappedFileCache.getUnchecked((Object)file.getAbsoluteFile());
                return BlocksFileReader.readBlocks(slice);
            }
        }));
        return BlockUtils.toBlocks(blocks);
    }

    @Override
    public boolean shardExists(UUID shardUuid) {
        return this.dao.shardExists(shardUuid);
    }

    @Override
    public void dropShard(UUID shardUuid) {
        this.shardBoundedExecutor.execute(shardUuid, new DropJob(shardUuid));
    }

    @Override
    public boolean isShardActive(UUID shardUuid) {
        return this.shardBoundedExecutor.isActive(shardUuid);
    }

    private static File createDirectory(File dir) throws IOException {
        Files.createDirectories(dir.toPath(), new FileAttribute[0]);
        return dir;
    }

    private class DropJob
    implements Runnable {
        private final UUID shardUuid;

        private DropJob(UUID shardUuid) {
            this.shardUuid = (UUID)Preconditions.checkNotNull((Object)shardUuid, (Object)"shardUuid is null");
        }

        @Override
        public void run() {
            List<String> shardFiles = DatabaseLocalStorageManager.this.dao.getShardFiles(this.shardUuid);
            for (String shardFile : shardFiles) {
                File file = new File(DatabaseLocalStorageManager.getShardPath(DatabaseLocalStorageManager.this.baseStorageDir, this.shardUuid), shardFile);
                if (file.delete()) continue;
                log.warn("failed to delete file: %s", new Object[]{file.getAbsolutePath()});
            }
            DatabaseLocalStorageManager.this.dao.dropShard(this.shardUuid);
        }
    }
}

