/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.block.Block;
import com.facebook.presto.block.BlockUtils;
import com.facebook.presto.operator.Page;
import com.facebook.presto.serde.BlocksFileEncoding;
import com.facebook.presto.serde.BlocksFileWriter;
import com.facebook.presto.spi.ColumnHandle;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.io.Files;
import com.google.common.io.OutputSupplier;
import com.google.common.primitives.Ints;
import io.airlift.units.DataSize;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;

public class ColumnFileHandle {
    private static final DataSize OUTPUT_BUFFER_SIZE = new DataSize(64.0, DataSize.Unit.KILOBYTE);
    private final UUID shardUuid;
    private final Map<ColumnHandle, File> files;
    private final Map<ColumnHandle, BlocksFileWriter> writers;
    private final AtomicBoolean committed = new AtomicBoolean();

    public static Builder builder(UUID shardUuid) {
        return new Builder(shardUuid);
    }

    private ColumnFileHandle(Builder builder) {
        this.shardUuid = builder.getShardUuid();
        this.files = new LinkedHashMap<ColumnHandle, File>(builder.getFiles());
        this.writers = new LinkedHashMap<ColumnHandle, BlocksFileWriter>(builder.getWriters());
    }

    public Map<ColumnHandle, File> getFiles() {
        return this.files;
    }

    public UUID getShardUuid() {
        return this.shardUuid;
    }

    public int append(Page page) {
        Preconditions.checkNotNull((Object)page, (Object)"page is null");
        Preconditions.checkState((!this.committed.get() ? 1 : 0) != 0, (Object)"already committed!");
        Block[] blocks = page.getBlocks();
        int[] tupleCount = new int[blocks.length];
        Preconditions.checkState((blocks.length == this.writers.size() ? 1 : 0) != 0, (String)"Block count does not match writer count (%s vs %s)!", (Object[])new Object[]{blocks.length, this.writers.size()});
        int i = 0;
        for (BlocksFileWriter writer : this.writers.values()) {
            Block block = blocks[i];
            writer.append(BlockUtils.toTupleIterable(block));
            tupleCount[i] = block.getPositionCount();
            if (i > 0) {
                Preconditions.checkState((tupleCount[i] == tupleCount[i - 1] ? 1 : 0) != 0, (String)"different tuple count (%s vs. %s) for block!", (Object[])new Object[]{tupleCount[i], tupleCount[i - 1]});
            }
            ++i;
        }
        return tupleCount[0];
    }

    public void commit() throws IOException {
        Throwable firstThrowable = null;
        Preconditions.checkState((!this.committed.getAndSet(true) ? 1 : 0) != 0, (Object)"already committed!");
        for (BlocksFileWriter writer : this.writers.values()) {
            try {
                writer.close();
            }
            catch (Throwable t) {
                if (firstThrowable != null) continue;
                firstThrowable = t;
            }
        }
        Throwables.propagateIfInstanceOf(firstThrowable, IOException.class);
    }

    private static class BufferedOutputSupplier
    implements OutputSupplier<OutputStream> {
        private final OutputSupplier<? extends OutputStream> supplier;
        private final long bufferSize;

        private BufferedOutputSupplier(OutputSupplier<? extends OutputStream> supplier, DataSize bufferSize) {
            this.supplier = (OutputSupplier)Preconditions.checkNotNull(supplier, (Object)"supplier is null");
            this.bufferSize = ((DataSize)Preconditions.checkNotNull((Object)bufferSize, (Object)"bufferSize is null")).toBytes();
        }

        public OutputStream getOutput() throws IOException {
            return new BufferedOutputStream((OutputStream)this.supplier.getOutput(), Ints.saturatedCast((long)this.bufferSize));
        }
    }

    public static class Builder {
        private final UUID shardUuid;
        private final Map<ColumnHandle, File> files = new LinkedHashMap<ColumnHandle, File>();
        private final Map<ColumnHandle, BlocksFileWriter> writers = new LinkedHashMap<ColumnHandle, BlocksFileWriter>();

        public Builder(UUID shardUuid) {
            this.shardUuid = (UUID)Preconditions.checkNotNull((Object)shardUuid, (Object)"shardUuid is null");
        }

        public Builder addColumn(ColumnHandle columnHandle, File targetFile, BlocksFileEncoding encoding) {
            Preconditions.checkNotNull((Object)columnHandle, (Object)"columnHandle is null");
            Preconditions.checkNotNull((Object)targetFile, (Object)"targetFile is null");
            Preconditions.checkNotNull((Object)((Object)encoding), (Object)"encoding is null");
            Preconditions.checkState((!targetFile.exists() ? 1 : 0) != 0, (String)"Can not write to existing file %s", (Object[])new Object[]{targetFile.getAbsolutePath()});
            this.files.put(columnHandle, targetFile);
            this.writers.put(columnHandle, new BlocksFileWriter(encoding, new BufferedOutputSupplier(Files.newOutputStreamSupplier((File)targetFile), OUTPUT_BUFFER_SIZE)));
            return this;
        }

        public Builder addColumn(ColumnHandle columnHandle, File targetFile) {
            Preconditions.checkNotNull((Object)columnHandle, (Object)"columnHandle is null");
            Preconditions.checkNotNull((Object)targetFile, (Object)"targetFile is null");
            this.files.put(columnHandle, targetFile);
            return this;
        }

        public ColumnFileHandle build() {
            Preconditions.checkArgument((this.files.size() > 0 ? 1 : 0) != 0, (Object)"must have at least one column");
            return new ColumnFileHandle(this);
        }

        private UUID getShardUuid() {
            return this.shardUuid;
        }

        private Map<ColumnHandle, File> getFiles() {
            return this.files;
        }

        private Map<ColumnHandle, BlocksFileWriter> getWriters() {
            return this.writers;
        }
    }
}

