/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.metadata.TableAlias;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.skife.jdbi.v2.exceptions.UnableToObtainConnectionException;
import org.skife.jdbi.v2.sqlobject.Bind;
import org.skife.jdbi.v2.sqlobject.BindBean;
import org.skife.jdbi.v2.sqlobject.SqlQuery;
import org.skife.jdbi.v2.sqlobject.SqlUpdate;
import org.skife.jdbi.v2.sqlobject.customizers.Mapper;

public interface AliasDao {
    @SqlUpdate(value="CREATE TABLE IF NOT EXISTS alias (\n  source_connector_id VARCHAR(255) NOT NULL,\n  source_schema_name VARCHAR(255) NOT NULL,\n  source_table_name VARCHAR(255) NOT NULL,\n  destination_connector_id VARCHAR(255) NOT NULL,\n  destination_schema_name VARCHAR(255) NOT NULL,\n  destination_table_name VARCHAR(255) NOT NULL,\n  UNIQUE(destination_connector_id, destination_schema_name, destination_table_name)\n)")
    public void createAliasTable();

    @SqlUpdate(value="INSERT INTO alias\n  (source_connector_id, source_schema_name, source_table_name, destination_connector_id, destination_schema_name, destination_table_name)\n  VALUES (:sourceConnectorId, :sourceSchemaName, :sourceTableName, :destinationConnectorId, :destinationSchemaName, :destinationTableName)")
    public long insertAlias(@BindBean TableAlias var1);

    @SqlUpdate(value="DELETE FROM alias\n  WHERE source_connector_id = :sourceConnectorId AND source_schema_name = :sourceSchemaName AND source_table_name = :sourceTableName")
    public void dropAlias(@BindBean TableAlias var1);

    @SqlQuery(value="SELECT * FROM alias WHERE source_connector_id = :connectorId AND source_schema_name = :schemaName AND source_table_name = :tableName")
    @Mapper(value=TableAlias.TableAliasMapper.class)
    public TableAlias getAlias(@Bind(value="connectorId") String var1, @Bind(value="schemaName") String var2, @Bind(value="tableName") String var3);

    @SqlQuery(value="SELECT * FROM alias")
    @Mapper(value=TableAlias.TableAliasMapper.class)
    public List<TableAlias> getAliases();

    public static final class Utils {
        public static final Logger log = Logger.get(AliasDao.class);

        public static void createTables(AliasDao dao) {
            dao.createAliasTable();
        }

        public static void createTablesWithRetry(AliasDao dao) throws InterruptedException {
            Duration delay = new Duration(10.0, TimeUnit.SECONDS);
            while (true) {
                try {
                    Utils.createTables(dao);
                    return;
                }
                catch (UnableToObtainConnectionException e) {
                    log.warn("Failed to connect to database. Will retry again in %s. Exception: %s", new Object[]{delay, e.getMessage()});
                    Thread.sleep(delay.toMillis());
                    continue;
                }
                break;
            }
        }
    }
}

