/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.importer;

import com.facebook.presto.importer.PeriodicImportJob;
import com.facebook.presto.metadata.QualifiedTableName;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

public final class PersistentPeriodicImportJob {
    private static final Function<PersistentPeriodicImportJob, Long> GET_JOB_ID = new Function<PersistentPeriodicImportJob, Long>(){

        public Long apply(PersistentPeriodicImportJob input) {
            return input.getJobId();
        }
    };
    private final long jobId;
    private final PeriodicImportJob importJob;

    public static Function<PersistentPeriodicImportJob, Long> jobIdGetter() {
        return GET_JOB_ID;
    }

    public PersistentPeriodicImportJob(long jobId, QualifiedTableName srcTable, QualifiedTableName dstTable, long interval) {
        this.importJob = new PeriodicImportJob(srcTable, dstTable, interval);
        this.jobId = jobId;
    }

    @JsonProperty
    public String getSrcCatalogName() {
        return this.importJob.getSrcCatalogName();
    }

    @JsonProperty
    public String getSrcSchemaName() {
        return this.importJob.getSrcSchemaName();
    }

    @JsonProperty
    public String getSrcTableName() {
        return this.importJob.getSrcTableName();
    }

    @JsonProperty
    public String getDstCatalogName() {
        return this.importJob.getDstCatalogName();
    }

    @JsonProperty
    public String getDstSchemaName() {
        return this.importJob.getDstSchemaName();
    }

    @JsonProperty
    public String getDstTableName() {
        return this.importJob.getDstTableName();
    }

    @JsonProperty
    public long getInterval() {
        return this.importJob.getIntervalSeconds();
    }

    @JsonProperty
    public long getJobId() {
        return this.jobId;
    }

    @VisibleForTesting
    PeriodicImportJob getImportJob() {
        return this.importJob;
    }

    public QualifiedTableName getSrcTable() {
        return this.importJob.getSrcTable();
    }

    public QualifiedTableName getDstTable() {
        return this.importJob.getDstTable();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.importJob, this.jobId});
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        PersistentPeriodicImportJob that = (PersistentPeriodicImportJob)object;
        return Objects.equal((Object)this.importJob, (Object)that.importJob) && this.jobId == that.jobId;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("importJob", (Object)this.importJob).add("jobId", this.jobId).toString();
    }

    public static class PersistentPeriodicImportJobMapper
    implements ResultSetMapper<PersistentPeriodicImportJob> {
        public PersistentPeriodicImportJob map(int index, ResultSet r, StatementContext ctx) throws SQLException {
            QualifiedTableName srcTable = new QualifiedTableName(r.getString("src_catalog_name"), r.getString("src_schema_name"), r.getString("src_table_name"));
            QualifiedTableName dstTable = new QualifiedTableName(r.getString("dst_catalog_name"), r.getString("dst_schema_name"), r.getString("dst_table_name"));
            return new PersistentPeriodicImportJob(r.getLong("job_id"), srcTable, dstTable, r.getLong("job_interval_seconds"));
        }
    }
}

