/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.importer;

import com.facebook.presto.client.ClientSession;
import com.facebook.presto.client.QueryResults;
import com.facebook.presto.client.StatementClient;
import com.facebook.presto.importer.AbstractPeriodicImportRunnable;
import com.facebook.presto.importer.ForPeriodicImport;
import com.facebook.presto.importer.JobStateFactory;
import com.facebook.presto.importer.PeriodicImportManager;
import com.facebook.presto.importer.PersistentPeriodicImportJob;
import com.facebook.presto.metadata.NodeManager;
import com.facebook.presto.metadata.QualifiedTableName;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import io.airlift.http.client.AsyncHttpClient;
import io.airlift.json.JsonCodec;
import io.airlift.log.Logger;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;

public class PeriodicImportRunnable
extends AbstractPeriodicImportRunnable {
    private static final Logger log = Logger.get(PeriodicImportRunnable.class);
    private final NodeManager nodeManager;
    private final AsyncHttpClient httpClient;
    private final JsonCodec<QueryResults> queryResultsCodec;

    PeriodicImportRunnable(PeriodicImportManager periodicImportManager, JobStateFactory.JobState jobState, NodeManager nodeManager, AsyncHttpClient httpClient, JsonCodec<QueryResults> queryResultsCodec) {
        super(jobState, periodicImportManager);
        this.nodeManager = (NodeManager)Preconditions.checkNotNull((Object)nodeManager, (Object)"nodeManager is null");
        this.httpClient = (AsyncHttpClient)Preconditions.checkNotNull((Object)httpClient, (Object)"httpClient is null");
        this.queryResultsCodec = (JsonCodec)Preconditions.checkNotNull(queryResultsCodec, (Object)"queryResultsCodec is null");
    }

    @Override
    public void doRun() {
        PersistentPeriodicImportJob job = this.jobState.getJob();
        QualifiedTableName dstTable = job.getDstTable();
        String sql = String.format("REFRESH MATERIALIZED VIEW %s", dstTable.getTableName());
        ClientSession session = new ClientSession(this.serverUri(), "periodic-import", "periodic-import", dstTable.getCatalogName(), dstTable.getSchemaName(), false);
        StatementClient client = new StatementClient(this.httpClient, this.queryResultsCodec, session, sql);
        ImmutableList result = ImmutableList.copyOf(PeriodicImportRunnable.flatten(new ResultsPageIterator(client)));
        log.debug("Query: %s, Result: %s", new Object[]{sql, result});
    }

    private URI serverUri() {
        return this.nodeManager.getCurrentNode().getHttpUri();
    }

    private static <T> Iterator<T> flatten(Iterator<Iterable<T>> iterator) {
        return Iterators.concat((Iterator)Iterators.transform(iterator, (Function)new Function<Iterable<T>, Iterator<T>>(){

            public Iterator<T> apply(Iterable<T> input) {
                return input.iterator();
            }
        }));
    }

    private static String failureMessage(QueryResults results) {
        return String.format("Query failed (#%s): %s", results.getId(), results.getError().getMessage());
    }

    private static class ResultsPageIterator
    extends AbstractIterator<Iterable<List<Object>>> {
        private final StatementClient client;

        private ResultsPageIterator(StatementClient client) {
            this.client = (StatementClient)Preconditions.checkNotNull((Object)client, (Object)"client is null");
        }

        protected Iterable<List<Object>> computeNext() {
            while (this.client.isValid()) {
                Iterable data = this.client.current().getData();
                this.client.advance();
                if (data == null) continue;
                return data;
            }
            if (this.client.isFailed()) {
                throw new IllegalStateException(PeriodicImportRunnable.failureMessage(this.client.finalResults()));
            }
            return (Iterable)this.endOfData();
        }
    }

    public static final class PeriodicImportRunnableFactory {
        private final PeriodicImportManager periodicImportManager;
        private final NodeManager nodeManager;
        private final AsyncHttpClient httpClient;
        private final JsonCodec<QueryResults> queryResultsCodec;

        @Inject
        public PeriodicImportRunnableFactory(PeriodicImportManager periodicImportManager, NodeManager nodeManager, @ForPeriodicImport AsyncHttpClient httpClient, JsonCodec<QueryResults> queryResultsCodec) {
            this.nodeManager = (NodeManager)Preconditions.checkNotNull((Object)nodeManager, (Object)"nodeManager is null");
            this.httpClient = (AsyncHttpClient)Preconditions.checkNotNull((Object)httpClient, (Object)"httpClient is null");
            this.queryResultsCodec = (JsonCodec)Preconditions.checkNotNull(queryResultsCodec, (Object)"queryResultsCodec is null");
            this.periodicImportManager = (PeriodicImportManager)Preconditions.checkNotNull((Object)periodicImportManager, (Object)"periodicImportManager is null");
        }

        public Runnable create(JobStateFactory.JobState jobState) {
            return new PeriodicImportRunnable(this.periodicImportManager, jobState, this.nodeManager, this.httpClient, this.queryResultsCodec);
        }
    }
}

