/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.importer;

import com.facebook.presto.importer.PeriodicImportJob;
import com.facebook.presto.importer.PeriodicImportRun;
import com.facebook.presto.importer.PersistentPeriodicImportJob;
import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import org.skife.jdbi.v2.sqlobject.Bind;
import org.skife.jdbi.v2.sqlobject.BindBean;
import org.skife.jdbi.v2.sqlobject.GetGeneratedKeys;
import org.skife.jdbi.v2.sqlobject.SqlQuery;
import org.skife.jdbi.v2.sqlobject.SqlUpdate;
import org.skife.jdbi.v2.sqlobject.customizers.Mapper;

public interface PeriodicImportDao {
    @SqlUpdate(value="CREATE TABLE IF NOT EXISTS job (\n  job_id BIGINT PRIMARY KEY AUTO_INCREMENT,\n  src_catalog_name VARCHAR(255) NOT NULL,\n  src_schema_name VARCHAR(255) NOT NULL,\n  src_table_name VARCHAR(255) NOT NULL,\n  dst_catalog_name VARCHAR(255) NOT NULL,\n  dst_schema_name VARCHAR(255) NOT NULL,\n  dst_table_name VARCHAR(255) NOT NULL,\n  job_interval_seconds INT NOT NULL,\n  enabled BOOLEAN NOT NULL DEFAULT TRUE\n)")
    public void createJobTable();

    @SqlUpdate(value="INSERT INTO job \n(src_catalog_name, src_schema_name, src_table_name,dst_catalog_name, dst_schema_name, dst_table_name, job_interval_seconds)\nVALUES (:srcCatalogName, :srcSchemaName, :srcTableName, :dstCatalogName, :dstSchemaName, :dstTableName, :intervalSeconds)")
    @GetGeneratedKeys
    public long insertJob(@BindBean PeriodicImportJob var1);

    @SqlUpdate(value="UPDATE job SET enabled = FALSE\nWHERE job_id = :jobId\n")
    public void dropJob(@Bind(value="jobId") long var1);

    @SqlQuery(value="SELECT COUNT(*) FROM job WHERE enabled = :enabled")
    public long getJobCount(@Bind(value="enabled") boolean var1);

    @SqlQuery(value="SELECT * FROM job WHERE job_id = :jobId")
    @Mapper(value=PersistentPeriodicImportJob.PersistentPeriodicImportJobMapper.class)
    public PersistentPeriodicImportJob getJob(@Bind(value="jobId") long var1);

    @SqlQuery(value="SELECT * FROM job WHERE enabled = :enabled")
    @Mapper(value=PersistentPeriodicImportJob.PersistentPeriodicImportJobMapper.class)
    public List<PersistentPeriodicImportJob> getJobs(@Bind(value="enabled") boolean var1);

    @SqlUpdate(value="CREATE TABLE IF NOT EXISTS run (\n  run_id BIGINT PRIMARY KEY AUTO_INCREMENT,\n  job_id BIGINT NOT NULL,\n  node_id VARCHAR(255) NOT NULL,\n  job_start_time DATETIME NOT NULL,\n  job_end_time DATETIME,\n  success BOOLEAN NOT NULL DEFAULT FALSE,\n  FOREIGN KEY (job_id) REFERENCES job (job_id) ON DELETE CASCADE\n)")
    public void createRunTable();

    @SqlUpdate(value="INSERT INTO run (job_id, node_id, job_start_time) VALUES (:jobId, :nodeId, CURRENT_TIMESTAMP)")
    @GetGeneratedKeys
    public long beginRun(@Bind(value="jobId") long var1, @Bind(value="nodeId") String var3);

    @SqlUpdate(value="UPDATE run SET success = :success,\n  job_end_time = CURRENT_TIMESTAMP\n  WHERE run_id = :runId\n")
    public void finishRun(@Bind(value="runId") long var1, @Bind(value="success") boolean var3);

    @SqlQuery(value="SELECT COUNT(*) FROM run\n  WHERE success = :success")
    public long getRunCount(@Bind(value="success") boolean var1);

    @SqlQuery(value="SELECT run.*\n  FROM run\n  JOIN (SELECT job_id, MAX(job_start_time) AS job_start_time FROM run GROUP BY job_id) AS a\n  ON (run.job_id = a.job_id AND run.job_start_time = a.job_start_time)\n  WHERE job_end_time IS NULL")
    @Mapper(value=PeriodicImportRun.PeriodicImportRunMapper.class)
    @VisibleForTesting
    public List<PeriodicImportRun> getJobsStarted();

    @SqlQuery(value="SELECT run.*\n  FROM run\n  JOIN (SELECT job_id, MAX(job_start_time) AS job_start_time FROM run GROUP BY job_id) AS a\n  ON (run.job_id = a.job_id AND run.job_start_time = a.job_start_time)\n  WHERE job_end_time IS NOT NULL AND success = :success")
    @Mapper(value=PeriodicImportRun.PeriodicImportRunMapper.class)
    @VisibleForTesting
    public List<PeriodicImportRun> getJobsFinished(@Bind(value="success") boolean var1);

    @SqlQuery(value="SELECT * FROM run WHERE run_id = :runId")
    @Mapper(value=PeriodicImportRun.PeriodicImportRunMapper.class)
    @VisibleForTesting
    public PeriodicImportRun getRun(@Bind(value="runId") long var1);

    public static final class Utils {
        public static void createTables(PeriodicImportDao dao) {
            dao.createJobTable();
            dao.createRunTable();
        }
    }
}

