/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.importer;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.units.Duration;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class PeriodicImportConfig {
    private boolean enabled = false;
    private int threadCount = 2;
    private Duration checkInterval = new Duration(10.0, TimeUnit.SECONDS);

    public boolean isEnabled() {
        return this.enabled;
    }

    @Config(value="periodic-import.enabled")
    @ConfigDescription(value="Run the periodic importer")
    public PeriodicImportConfig setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Min(value=1L)
    public int getThreadCount() {
        return this.threadCount;
    }

    @Config(value="periodic-import.thread-count")
    @ConfigDescription(value="Number of execution threads for the periodic importer")
    public PeriodicImportConfig setThreadCount(int threadCount) {
        this.threadCount = threadCount;
        return this;
    }

    @NotNull
    public Duration getCheckInterval() {
        return this.checkInterval;
    }

    @Config(value="periodic-import.check-interval")
    @ConfigDescription(value="Check interval for the periodic importer")
    public PeriodicImportConfig setCheckInterval(Duration checkInterval) {
        this.checkInterval = checkInterval;
        return this;
    }
}

