/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.importer;

import com.facebook.presto.importer.JobStateFactory;
import com.facebook.presto.importer.PeriodicImportManager;
import com.google.common.base.Preconditions;
import io.airlift.log.Logger;

public abstract class AbstractPeriodicImportRunnable
implements Runnable {
    private static final Logger log = Logger.get(AbstractPeriodicImportRunnable.class);
    protected final JobStateFactory.JobState jobState;
    protected final PeriodicImportManager periodicImportManager;

    protected AbstractPeriodicImportRunnable(JobStateFactory.JobState jobState, PeriodicImportManager periodicImportManager) {
        this.jobState = (JobStateFactory.JobState)Preconditions.checkNotNull((Object)jobState, (Object)"jobState is null!");
        this.periodicImportManager = (PeriodicImportManager)Preconditions.checkNotNull((Object)periodicImportManager, (Object)"periodicImportManager is null!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long jobId = this.jobState.getJob().getJobId();
        long runId = this.periodicImportManager.beginRun(jobId);
        boolean success = false;
        try {
            long startTime = System.currentTimeMillis();
            log.debug("Job %d: Scheduled for execution!", new Object[]{jobId});
            long lastRun = this.jobState.getLastRun();
            if (lastRun > 0L && startTime - lastRun < this.jobState.getJob().getInterval() * 900L) {
                log.debug("Job %d: Last run %dms ago; less than %dms, skipping", new Object[]{jobId, startTime - lastRun, this.jobState.getJob().getInterval() * 1000L});
                return;
            }
            this.jobState.setLastRun(startTime);
            this.doRun();
            log.debug("Job %d: Done!", new Object[]{jobId});
            success = true;
        }
        catch (RuntimeException e) {
            log.warn((Throwable)e, "Job %d: ", new Object[]{jobId});
        }
        finally {
            if (!Thread.currentThread().isInterrupted()) {
                this.periodicImportManager.endRun(runId, success);
            }
        }
    }

    protected abstract void doRun();
}

