/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.execution.BufferInfo;
import com.facebook.presto.execution.SharedBuffer;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class SharedBufferInfo {
    private final SharedBuffer.QueueState state;
    private final long masterSequenceId;
    private final long pagesAdded;
    private final List<BufferInfo> buffers;

    @JsonCreator
    public SharedBufferInfo(@JsonProperty(value="state") SharedBuffer.QueueState state, @JsonProperty(value="masterSequenceId") long masterSequenceId, @JsonProperty(value="pagesAdded") long pagesAdded, @JsonProperty(value="buffers") List<BufferInfo> buffers) {
        this.state = state;
        this.masterSequenceId = masterSequenceId;
        this.pagesAdded = pagesAdded;
        this.buffers = ImmutableList.copyOf(buffers);
    }

    @JsonProperty
    public SharedBuffer.QueueState getState() {
        return this.state;
    }

    @JsonProperty
    public long getMasterSequenceId() {
        return this.masterSequenceId;
    }

    @JsonProperty
    public long getPagesAdded() {
        return this.pagesAdded;
    }

    @JsonProperty
    public List<BufferInfo> getBuffers() {
        return this.buffers;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.state, this.pagesAdded, this.buffers, this.masterSequenceId});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SharedBufferInfo other = (SharedBufferInfo)obj;
        return Objects.equal((Object)((Object)this.state), (Object)((Object)other.state)) && Objects.equal((Object)this.pagesAdded, (Object)other.pagesAdded) && Objects.equal(this.buffers, other.buffers) && Objects.equal((Object)this.masterSequenceId, (Object)other.masterSequenceId);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("state", (Object)this.state).add("pagesAdded", this.pagesAdded).add("buffers", this.buffers).add("masterSequenceId", this.masterSequenceId).toString();
    }
}

