/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.execution.NodeSchedulerConfig;
import com.facebook.presto.metadata.Node;
import com.facebook.presto.metadata.NodeManager;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.Split;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.SetMultimap;
import com.google.common.net.InetAddresses;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import org.weakref.jmx.Managed;

public class NodeScheduler {
    private final NodeManager nodeManager;
    private final AtomicLong scheduleLocal = new AtomicLong();
    private final AtomicLong scheduleRack = new AtomicLong();
    private final AtomicLong scheduleRandom = new AtomicLong();
    private final int minCandidates;

    @Inject
    public NodeScheduler(NodeManager nodeManager, NodeSchedulerConfig config) {
        this.nodeManager = nodeManager;
        this.minCandidates = config.getMinCandidates();
    }

    @Managed
    public long getScheduleLocal() {
        return this.scheduleLocal.get();
    }

    @Managed
    public long getScheduleRack() {
        return this.scheduleRack.get();
    }

    @Managed
    public long getScheduleRandom() {
        return this.scheduleRandom.get();
    }

    @Managed
    public void reset() {
        this.scheduleLocal.set(0L);
        this.scheduleRack.set(0L);
        this.scheduleRandom.set(0L);
    }

    public NodeSelector createNodeSelector(final String dataSourceName, Comparator<Node> nodeComparator) {
        Supplier nodeMap = Suppliers.memoizeWithExpiration((Supplier)new Supplier<NodeMap>(){

            public NodeMap get() {
                ImmutableSetMultimap.Builder byHostAndPort = ImmutableSetMultimap.builder();
                ImmutableSetMultimap.Builder byHost = ImmutableSetMultimap.builder();
                ImmutableSetMultimap.Builder byRack = ImmutableSetMultimap.builder();
                Set<Node> nodes = dataSourceName != null ? NodeScheduler.this.nodeManager.getActiveDatasourceNodes(dataSourceName) : NodeScheduler.this.nodeManager.getAllNodes().getActiveNodes();
                for (Node node : nodes) {
                    try {
                        byHostAndPort.put((Object)node.getHostAndPort(), (Object)node);
                        InetAddress host = InetAddress.getByName(node.getHttpUri().getHost());
                        byHost.put((Object)host, (Object)node);
                        byRack.put((Object)Rack.of(host), (Object)node);
                    }
                    catch (UnknownHostException e) {}
                }
                return new NodeMap((SetMultimap<HostAddress, Node>)byHostAndPort.build(), (SetMultimap<InetAddress, Node>)byHost.build(), (SetMultimap<Rack, Node>)byRack.build());
            }
        }, (long)5L, (TimeUnit)TimeUnit.SECONDS);
        return new NodeSelector(nodeComparator, (Supplier<NodeMap>)nodeMap);
    }

    private static <T> Iterable<T> lazyShuffle(final Iterable<T> iterable) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new AbstractIterator<T>(){
                    List<T> list;
                    int limit;
                    {
                        this.list = Lists.newArrayList((Iterable)iterable);
                        this.limit = this.list.size();
                    }

                    protected T computeNext() {
                        if (this.limit == 0) {
                            return this.endOfData();
                        }
                        int position = ThreadLocalRandom.current().nextInt(this.limit);
                        Object result = this.list.get(position);
                        this.list.set(position, this.list.get(this.limit - 1));
                        --this.limit;
                        return result;
                    }
                };
            }
        };
    }

    private static class Rack {
        private int id;

        public static Rack of(InetAddress address) {
            int id = InetAddresses.coerceToInteger((InetAddress)address) & 0xFFFFFF00;
            return new Rack(id);
        }

        private Rack(int id) {
            this.id = id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Rack rack = (Rack)o;
            return this.id == rack.id;
        }

        public int hashCode() {
            return this.id;
        }
    }

    private static class NodeMap {
        private final SetMultimap<HostAddress, Node> nodesByHostAndPort;
        private final SetMultimap<InetAddress, Node> nodesByHost;
        private final SetMultimap<Rack, Node> nodesByRack;

        public NodeMap(SetMultimap<HostAddress, Node> nodesByHostAndPort, SetMultimap<InetAddress, Node> nodesByHost, SetMultimap<Rack, Node> nodesByRack) {
            this.nodesByHostAndPort = nodesByHostAndPort;
            this.nodesByHost = nodesByHost;
            this.nodesByRack = nodesByRack;
        }

        private SetMultimap<HostAddress, Node> getNodesByHostAndPort() {
            return this.nodesByHostAndPort;
        }

        public SetMultimap<InetAddress, Node> getNodesByHost() {
            return this.nodesByHost;
        }

        public SetMultimap<Rack, Node> getNodesByRack() {
            return this.nodesByRack;
        }
    }

    public class NodeSelector {
        private final Comparator<Node> nodeComparator;
        private final AtomicReference<Supplier<NodeMap>> nodeMap;

        public NodeSelector(Comparator<Node> nodeComparator, Supplier<NodeMap> nodeMap) {
            this.nodeComparator = nodeComparator;
            this.nodeMap = new AtomicReference<Supplier<NodeMap>>(nodeMap);
        }

        public void lockDownNodes() {
            this.nodeMap.set((Supplier<NodeMap>)Suppliers.ofInstance((Object)this.nodeMap.get().get()));
        }

        public List<Node> allNodes() {
            return ImmutableList.copyOf((Collection)((NodeMap)this.nodeMap.get().get()).getNodesByHostAndPort().values());
        }

        public List<Node> selectRandomNodes(int limit) {
            Preconditions.checkArgument((limit > 0 ? 1 : 0) != 0, (Object)"limit must be at least 1");
            List nodes = new ArrayList(((NodeMap)this.nodeMap.get().get()).getNodesByHostAndPort().values());
            if (nodes.size() > limit) {
                Collections.shuffle(nodes, ThreadLocalRandom.current());
                nodes = nodes.subList(0, limit);
            }
            return ImmutableList.copyOf(nodes);
        }

        public Node selectRandomNode() {
            ArrayList nodes = new ArrayList(((NodeMap)this.nodeMap.get().get()).getNodesByHostAndPort().values());
            Preconditions.checkState((!nodes.isEmpty() ? 1 : 0) != 0, (Object)"Cluster does not have any active nodes");
            Collections.shuffle(nodes, ThreadLocalRandom.current());
            return (Node)nodes.get(0);
        }

        public Node selectNode(Split split) {
            List<Node> nodes = this.selectNodes((NodeMap)this.nodeMap.get().get(), split, NodeScheduler.this.minCandidates);
            Preconditions.checkState((!nodes.isEmpty() ? 1 : 0) != 0, (Object)"No nodes available to run query");
            Node chosen = (Node)Ordering.from(this.nodeComparator).min(nodes);
            return chosen;
        }

        private List<Node> selectNodes(NodeMap nodeMap, Split split, int minCount) {
            InetAddress address;
            LinkedHashSet<Node> chosen = new LinkedHashSet<Node>(minCount);
            for (HostAddress hint : split.getAddresses()) {
                for (Node node : nodeMap.getNodesByHostAndPort().get((Object)hint)) {
                    if (!chosen.add(node)) continue;
                    NodeScheduler.this.scheduleLocal.incrementAndGet();
                }
                try {
                    address = hint.toInetAddress();
                }
                catch (UnknownHostException e) {
                    continue;
                }
                if (hint.hasPort() && !split.isRemotelyAccessible()) continue;
                for (Node node : nodeMap.getNodesByHost().get((Object)address)) {
                    if (!chosen.add(node)) continue;
                    NodeScheduler.this.scheduleLocal.incrementAndGet();
                }
            }
            if (split.isRemotelyAccessible() && chosen.size() < minCount) {
                for (HostAddress hint : split.getAddresses()) {
                    try {
                        address = hint.toInetAddress();
                    }
                    catch (UnknownHostException e) {
                        continue;
                    }
                    for (Node node : nodeMap.getNodesByRack().get((Object)Rack.of(address))) {
                        if (chosen.add(node)) {
                            NodeScheduler.this.scheduleRack.incrementAndGet();
                        }
                        if (chosen.size() != minCount) continue;
                        break;
                    }
                    if (chosen.size() != minCount) continue;
                    break;
                }
            }
            if (split.isRemotelyAccessible() && chosen.size() < minCount) {
                for (Node node : NodeScheduler.lazyShuffle(nodeMap.getNodesByHost().values())) {
                    if (chosen.add(node)) {
                        NodeScheduler.this.scheduleRandom.incrementAndGet();
                    }
                    if (chosen.size() != minCount) continue;
                    break;
                }
            }
            return ImmutableList.copyOf(chosen);
        }
    }
}

