/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.execution.LocationFactory;
import com.facebook.presto.execution.QueryExecution;
import com.facebook.presto.execution.QueryId;
import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.execution.StageId;
import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.metadata.AliasDao;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.metadata.NativeTableHandle;
import com.facebook.presto.metadata.QualifiedTableName;
import com.facebook.presto.metadata.TableAlias;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.sql.analyzer.Session;
import com.facebook.presto.sql.tree.CreateAlias;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.util.Threads;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import io.airlift.concurrent.ThreadPoolExecutorMBean;
import io.airlift.units.Duration;
import java.net.URI;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import javax.inject.Inject;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class CreateAliasExecution
implements QueryExecution {
    private final CreateAlias statement;
    private final MetadataManager metadataManager;
    private final AliasDao aliasDao;
    private final QueryStateMachine stateMachine;

    CreateAliasExecution(QueryId queryId, String query, Session session, URI self, CreateAlias statement, MetadataManager metadataManager, AliasDao aliasDao, Executor executor) {
        this.statement = statement;
        this.metadataManager = metadataManager;
        this.aliasDao = aliasDao;
        this.stateMachine = new QueryStateMachine(queryId, query, session, self, executor);
    }

    @Override
    public void start() {
        try {
            if (!this.stateMachine.starting()) {
                return;
            }
            this.stateMachine.recordExecutionStart();
            this.createAlias();
            this.stateMachine.finished();
        }
        catch (RuntimeException e) {
            this.fail(e);
        }
    }

    @Override
    public Duration waitForStateChange(QueryState currentState, Duration maxWait) throws InterruptedException {
        return this.stateMachine.waitForStateChange(currentState, maxWait);
    }

    @Override
    public void addStateChangeListener(StateMachine.StateChangeListener<QueryState> stateChangeListener) {
        this.stateMachine.addStateChangeListener(stateChangeListener);
    }

    @Override
    public void cancel() {
        this.stateMachine.cancel();
    }

    @Override
    public void fail(Throwable cause) {
        this.stateMachine.fail(cause);
    }

    @Override
    public void cancelStage(StageId stageId) {
    }

    @Override
    public void recordHeartbeat() {
        this.stateMachine.recordHeartbeat();
    }

    @Override
    public QueryInfo getQueryInfo() {
        return this.stateMachine.getQueryInfoWithoutDetails();
    }

    private void createAlias() {
        QualifiedTableName aliasTableName = MetadataUtil.createQualifiedTableName(this.stateMachine.getSession(), this.statement.getAlias());
        Optional<TableHandle> aliasTableHandle = this.metadataManager.getTableHandle(aliasTableName);
        Preconditions.checkState((boolean)aliasTableHandle.isPresent(), (String)"Table %s does not exist", (Object[])new Object[]{aliasTableHandle});
        Preconditions.checkState((boolean)(aliasTableHandle.get() instanceof NativeTableHandle), (Object)"Can only use a native table as alias");
        String aliasConnectorId = this.metadataManager.getConnectorId((TableHandle)aliasTableHandle.get());
        QualifiedTableName remoteTableName = MetadataUtil.createQualifiedTableName(this.stateMachine.getSession(), this.statement.getRemote());
        Optional<TableHandle> remoteTableHandle = this.metadataManager.getTableHandle(remoteTableName);
        Preconditions.checkState((boolean)remoteTableHandle.isPresent(), (String)"Table %s does not exist", (Object[])new Object[]{remoteTableName});
        String remoteConnectorId = this.metadataManager.getConnectorId((TableHandle)remoteTableHandle.get());
        TableAlias tableAlias = new TableAlias(remoteConnectorId, remoteTableName.getSchemaName(), remoteTableName.getTableName(), aliasConnectorId, aliasTableName.getSchemaName(), aliasTableName.getTableName());
        this.aliasDao.insertAlias(tableAlias);
        this.stateMachine.finished();
    }

    public static class CreateAliasExecutionFactory
    implements QueryExecution.QueryExecutionFactory<CreateAliasExecution> {
        private final LocationFactory locationFactory;
        private final MetadataManager metadataManager;
        private final AliasDao aliasDao;
        private final ExecutorService executor;
        private final ThreadPoolExecutorMBean executorMBean;

        @Inject
        CreateAliasExecutionFactory(LocationFactory locationFactory, MetadataManager metadataManager, AliasDao aliasDao) {
            this.locationFactory = (LocationFactory)Preconditions.checkNotNull((Object)locationFactory, (Object)"locationFactory is null");
            this.metadataManager = (MetadataManager)Preconditions.checkNotNull((Object)metadataManager, (Object)"metadataManager is null");
            this.aliasDao = (AliasDao)Preconditions.checkNotNull((Object)aliasDao, (Object)"aliasDao is null");
            this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed("alias-scheduler-%d"));
            this.executorMBean = new ThreadPoolExecutorMBean((ThreadPoolExecutor)this.executor);
        }

        @Managed
        @Nested
        public ThreadPoolExecutorMBean getExecutor() {
            return this.executorMBean;
        }

        @Override
        public CreateAliasExecution createQueryExecution(QueryId queryId, String query, Session session, Statement statement) {
            return new CreateAliasExecution(queryId, query, session, this.locationFactory.createQueryLocation(queryId), (CreateAlias)statement, this.metadataManager, this.aliasDao, this.executor);
        }
    }
}

