/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.system;

import com.facebook.presto.connector.system.SystemTableHandle;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.Split;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;

public class SystemSplit
implements Split {
    private final SystemTableHandle tableHandle;
    private final Map<String, Object> filters;
    private final List<HostAddress> addresses;

    public SystemSplit(SystemTableHandle tableHandle, Map<String, Object> filters, HostAddress address) {
        this(tableHandle, filters, (List<HostAddress>)ImmutableList.of((Object)Preconditions.checkNotNull((Object)address, (Object)"address is null")));
    }

    @JsonCreator
    public SystemSplit(@JsonProperty(value="tableHandle") SystemTableHandle tableHandle, @JsonProperty(value="filters") Map<String, Object> filters, @JsonProperty(value="addresses") List<HostAddress> addresses) {
        this.tableHandle = (SystemTableHandle)Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
        this.filters = (Map)Preconditions.checkNotNull(filters, (Object)"filters is null");
        Preconditions.checkNotNull(addresses, (Object)"hosts is null");
        Preconditions.checkArgument((!addresses.isEmpty() ? 1 : 0) != 0, (Object)"hosts is empty");
        this.addresses = ImmutableList.copyOf(addresses);
    }

    public boolean isRemotelyAccessible() {
        return false;
    }

    @JsonProperty
    public List<HostAddress> getAddresses() {
        return this.addresses;
    }

    @JsonProperty
    public SystemTableHandle getTableHandle() {
        return this.tableHandle;
    }

    @JsonProperty
    public Map<String, Object> getFilters() {
        return this.filters;
    }

    public Object getInfo() {
        return this;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("tableHandle", (Object)this.tableHandle).add("filters", this.filters).add("addresses", this.addresses).toString();
    }
}

