/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.system;

import com.facebook.presto.metadata.AllNodes;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.metadata.Node;
import com.facebook.presto.metadata.NodeManager;
import com.facebook.presto.spi.ColumnType;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.InMemoryRecordSet;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SystemTable;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import javax.inject.Inject;

public class NodesSystemTable
implements SystemTable {
    public static final SchemaTableName NODES_TABLE_NAME = new SchemaTableName("sys", "node");
    public static final ConnectorTableMetadata NODES_TABLE = MetadataUtil.TableMetadataBuilder.tableMetadataBuilder(NODES_TABLE_NAME).column("node_id", ColumnType.STRING).column("http_uri", ColumnType.STRING).column("node_version", ColumnType.STRING).column("is_active", ColumnType.BOOLEAN).build();
    private final NodeManager nodeManager;

    @Inject
    public NodesSystemTable(NodeManager nodeManager) {
        this.nodeManager = (NodeManager)Preconditions.checkNotNull((Object)nodeManager, (Object)"nodeManager is null");
    }

    public boolean isDistributed() {
        return false;
    }

    public ConnectorTableMetadata getTableMetadata() {
        return NODES_TABLE;
    }

    public List<ColumnType> getColumnTypes() {
        return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)NODES_TABLE.getColumns(), MetadataUtil.columnTypeGetter()));
    }

    public RecordCursor cursor() {
        InMemoryRecordSet.Builder table = InMemoryRecordSet.builder((ConnectorTableMetadata)NODES_TABLE);
        AllNodes allNodes = this.nodeManager.getAllNodes();
        for (Node node : allNodes.getActiveNodes()) {
            table.addRow(new Object[]{node.getNodeIdentifier(), node.getHttpUri().toString(), node.getNodeVersion().toString(), Boolean.TRUE});
        }
        for (Node node : allNodes.getInactiveNodes()) {
            table.addRow(new Object[]{node.getNodeIdentifier(), node.getHttpUri().toString(), node.getNodeVersion().toString(), Boolean.FALSE});
        }
        return table.build().cursor();
    }
}

