/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.system;

import com.facebook.presto.metadata.AliasDao;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.metadata.TableAlias;
import com.facebook.presto.spi.ColumnType;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.InMemoryRecordSet;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SystemTable;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import javax.inject.Inject;

public class AliasSystemTable
implements SystemTable {
    public static final SchemaTableName ALIAS_TABLE_NAME = new SchemaTableName("sys", "alias");
    public static final ConnectorTableMetadata ALIAS_TABLE = MetadataUtil.TableMetadataBuilder.tableMetadataBuilder(ALIAS_TABLE_NAME).column("source_catalog", ColumnType.STRING).column("table", ColumnType.STRING).column("destination_catalog", ColumnType.STRING).column("alias", ColumnType.STRING).build();
    private final AliasDao aliasDao;

    @Inject
    public AliasSystemTable(AliasDao aliasDao) {
        this.aliasDao = (AliasDao)Preconditions.checkNotNull((Object)aliasDao, (Object)"aliasDao is null");
    }

    public boolean isDistributed() {
        return false;
    }

    public ConnectorTableMetadata getTableMetadata() {
        return ALIAS_TABLE;
    }

    public List<ColumnType> getColumnTypes() {
        return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)ALIAS_TABLE.getColumns(), MetadataUtil.columnTypeGetter()));
    }

    public RecordCursor cursor() {
        InMemoryRecordSet.Builder table = InMemoryRecordSet.builder((ConnectorTableMetadata)ALIAS_TABLE);
        for (TableAlias tableAlias : this.aliasDao.getAliases()) {
            table.addRow(new Object[]{tableAlias.getSourceConnectorId(), new SchemaTableName(tableAlias.getSourceSchemaName(), tableAlias.getSourceTableName()).toString(), tableAlias.getDestinationConnectorId(), new SchemaTableName(tableAlias.getDestinationSchemaName(), tableAlias.getDestinationTableName()).toString()});
        }
        return table.build().cursor();
    }
}

