/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.jmx;

import com.facebook.presto.connector.jmx.JmxConnectorId;
import com.facebook.presto.connector.jmx.JmxSplit;
import com.facebook.presto.connector.jmx.JmxTableHandle;
import com.facebook.presto.metadata.Node;
import com.facebook.presto.metadata.NodeManager;
import com.facebook.presto.spi.ConnectorSplitManager;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.Partition;
import com.facebook.presto.spi.PartitionResult;
import com.facebook.presto.spi.Split;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.TupleDomain;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import javax.inject.Inject;

public class JmxSplitManager
implements ConnectorSplitManager {
    private final String connectorId;
    private final NodeManager nodeManager;

    @Inject
    public JmxSplitManager(JmxConnectorId jmxConnectorId, NodeManager nodeManager) {
        this.connectorId = ((JmxConnectorId)Preconditions.checkNotNull((Object)jmxConnectorId, (Object)"jmxConnectorId is null")).toString();
        this.nodeManager = (NodeManager)Preconditions.checkNotNull((Object)nodeManager, (Object)"nodeManager is null");
    }

    public String getConnectorId() {
        return this.connectorId;
    }

    public boolean canHandle(TableHandle tableHandle) {
        return tableHandle instanceof JmxTableHandle && ((JmxTableHandle)tableHandle).getConnectorId().equals(this.connectorId);
    }

    public PartitionResult getPartitions(TableHandle table, TupleDomain tupleDomain) {
        Preconditions.checkNotNull((Object)table, (Object)"table is null");
        Preconditions.checkNotNull((Object)tupleDomain, (Object)"tupleDomain is null");
        Preconditions.checkArgument((boolean)(table instanceof JmxTableHandle), (Object)"TableHandle must be an JmxTableHandle");
        JmxTableHandle jmxTableHandle = (JmxTableHandle)table;
        ImmutableList partitions = ImmutableList.of((Object)new JmxPartition(jmxTableHandle));
        return new PartitionResult((List)partitions, tupleDomain);
    }

    public Iterable<Split> getPartitionSplits(TableHandle table, List<Partition> partitions) {
        Preconditions.checkNotNull(partitions, (Object)"partitions is null");
        if (partitions.isEmpty()) {
            return ImmutableList.of();
        }
        Partition partition = (Partition)Iterables.getOnlyElement(partitions);
        Preconditions.checkArgument((boolean)(partition instanceof JmxPartition), (Object)"Partition must be an jmx partition");
        JmxPartition jmxPartition = (JmxPartition)partition;
        ImmutableList.Builder splits = ImmutableList.builder();
        for (Node node : this.nodeManager.getAllNodes().getActiveNodes()) {
            splits.add((Object)new JmxSplit(jmxPartition.tableHandle, (List<HostAddress>)ImmutableList.of((Object)node.getHostAndPort())));
        }
        return splits.build();
    }

    public static class JmxPartition
    implements Partition {
        private final JmxTableHandle tableHandle;

        public JmxPartition(JmxTableHandle tableHandle) {
            this.tableHandle = (JmxTableHandle)Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
        }

        public JmxTableHandle getTableHandle() {
            return this.tableHandle;
        }

        public String getPartitionId() {
            return "jmx";
        }

        public TupleDomain getTupleDomain() {
            return TupleDomain.all();
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("tableHandle", (Object)this.tableHandle).toString();
        }
    }
}

