/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.informationSchema;

import com.facebook.presto.connector.informationSchema.InformationSchemaColumnHandle;
import com.facebook.presto.connector.informationSchema.InformationSchemaSplit;
import com.facebook.presto.connector.informationSchema.InformationSchemaTableHandle;
import com.facebook.presto.metadata.NodeManager;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorSplitManager;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.Partition;
import com.facebook.presto.spi.PartitionResult;
import com.facebook.presto.spi.Split;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.TupleDomain;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;

public class InformationSchemaSplitManager
implements ConnectorSplitManager {
    private final NodeManager nodeManager;

    @Inject
    public InformationSchemaSplitManager(NodeManager nodeManager) {
        this.nodeManager = (NodeManager)Preconditions.checkNotNull((Object)nodeManager, (Object)"nodeManager is null");
    }

    public String getConnectorId() {
        return null;
    }

    public boolean canHandle(TableHandle handle) {
        return handle instanceof InformationSchemaTableHandle;
    }

    public PartitionResult getPartitions(TableHandle table, TupleDomain tupleDomain) {
        Preconditions.checkNotNull((Object)table, (Object)"table is null");
        Preconditions.checkNotNull((Object)tupleDomain, (Object)"tupleDomain is null");
        Preconditions.checkArgument((boolean)(table instanceof InformationSchemaTableHandle), (Object)"TableHandle must be an InformationSchemaTableHandle");
        InformationSchemaTableHandle informationSchemaTableHandle = (InformationSchemaTableHandle)table;
        Map bindings = tupleDomain.extractFixedValues();
        ImmutableList partitions = ImmutableList.of((Object)new InformationSchemaPartition(informationSchemaTableHandle, bindings));
        return new PartitionResult((List)partitions, tupleDomain);
    }

    public Iterable<Split> getPartitionSplits(TableHandle table, List<Partition> partitions) {
        Preconditions.checkNotNull(partitions, (Object)"partitions is null");
        if (partitions.isEmpty()) {
            return ImmutableList.of();
        }
        Partition partition = (Partition)Iterables.getOnlyElement(partitions);
        Preconditions.checkArgument((boolean)(partition instanceof InformationSchemaPartition), (Object)"Partition must be an informationSchema partition");
        InformationSchemaPartition informationSchemaPartition = (InformationSchemaPartition)partition;
        ImmutableList localAddress = ImmutableList.of((Object)this.nodeManager.getCurrentNode().getHostAndPort());
        ImmutableMap.Builder filters = ImmutableMap.builder();
        for (Map.Entry<ColumnHandle, Comparable<?>> entry : informationSchemaPartition.getFilters().entrySet()) {
            InformationSchemaColumnHandle informationSchemaColumnHandle = (InformationSchemaColumnHandle)entry.getKey();
            filters.put((Object)informationSchemaColumnHandle.getColumnName(), entry.getValue());
        }
        InformationSchemaSplit split = new InformationSchemaSplit(informationSchemaPartition.table, (Map<String, Object>)filters.build(), (List<HostAddress>)localAddress);
        return ImmutableList.of((Object)split);
    }

    public static class InformationSchemaPartition
    implements Partition {
        private final InformationSchemaTableHandle table;
        private final Map<ColumnHandle, Comparable<?>> filters;

        public InformationSchemaPartition(InformationSchemaTableHandle table, Map<ColumnHandle, Comparable<?>> filters) {
            this.table = (InformationSchemaTableHandle)Preconditions.checkNotNull((Object)table, (Object)"table is null");
            this.filters = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(filters, (Object)"filters is null")));
        }

        public InformationSchemaTableHandle getTable() {
            return this.table;
        }

        public String getPartitionId() {
            return this.table.getSchemaTableName().toString();
        }

        public TupleDomain getTupleDomain() {
            return TupleDomain.withFixedValues(this.filters);
        }

        public Map<ColumnHandle, Comparable<?>> getFilters() {
            return this.filters;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("table", (Object)this.table).add("filters", this.filters).toString();
        }
    }
}

