/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.dual;

import com.facebook.presto.block.BlockIterable;
import com.facebook.presto.connector.dual.DualColumnHandle;
import com.facebook.presto.connector.dual.DualMetadata;
import com.facebook.presto.connector.dual.DualSplit;
import com.facebook.presto.metadata.InternalTable;
import com.facebook.presto.operator.AlignmentOperator;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.Split;
import com.facebook.presto.split.ConnectorDataStreamProvider;
import com.facebook.presto.tuple.TupleInfo;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.inject.Inject;

public class DualDataStreamProvider
implements ConnectorDataStreamProvider {
    private static final InternalTable DATA = InternalTable.builder((List<ColumnMetadata>)ImmutableList.of((Object)DualMetadata.COLUMN_METADATA)).add(TupleInfo.SINGLE_VARBINARY.builder().append("X").build()).build();

    @Inject
    public DualDataStreamProvider() {
    }

    @Override
    public boolean canHandle(Split split) {
        return split instanceof DualSplit;
    }

    @Override
    public Operator createNewDataStream(OperatorContext operatorContext, Split split, List<ColumnHandle> columns) {
        return new AlignmentOperator(operatorContext, this.createChannels(split, columns));
    }

    private List<BlockIterable> createChannels(Split split, List<ColumnHandle> columns) {
        Preconditions.checkNotNull((Object)split, (Object)"split is null");
        Preconditions.checkArgument((boolean)(split instanceof DualSplit), (String)"Split must be of type %s, not %s", (Object[])new Object[]{DualSplit.class.getName(), split.getClass().getName()});
        Preconditions.checkNotNull(columns, (Object)"columns is null");
        Preconditions.checkArgument((!columns.isEmpty() ? 1 : 0) != 0, (Object)"must provide at least one column");
        ImmutableList.Builder list = ImmutableList.builder();
        for (ColumnHandle column : columns) {
            Preconditions.checkArgument((boolean)(column instanceof DualColumnHandle), (String)"column must be of type %s, not %s", (Object[])new Object[]{DualColumnHandle.class.getName(), column.getClass().getName()});
            DualColumnHandle dualColumn = (DualColumnHandle)column;
            list.add((Object)DATA.getColumn(dualColumn.getColumnName()));
        }
        return list.build();
    }
}

