/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.byteCode.instruction;

import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.ByteCodeVisitor;
import com.facebook.presto.byteCode.OpCodes;
import com.facebook.presto.byteCode.instruction.InstructionNode;
import com.facebook.presto.byteCode.instruction.LabelNode;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.objectweb.asm.MethodVisitor;

public class JumpInstruction
implements InstructionNode {
    private final OpCodes opCode;
    private final LabelNode label;

    public static InstructionNode jump(LabelNode label) {
        return new JumpInstruction(OpCodes.GOTO, label);
    }

    public static InstructionNode jumpIfEqualZero(LabelNode label) {
        return new JumpInstruction(OpCodes.IFEQ, label);
    }

    public static InstructionNode jumpIfNotEqualZero(LabelNode label) {
        return new JumpInstruction(OpCodes.IFNE, label);
    }

    public static InstructionNode jumpIfLessThanZero(LabelNode label) {
        return new JumpInstruction(OpCodes.IFLT, label);
    }

    public static InstructionNode jumpIfGreaterThanZero(LabelNode label) {
        return new JumpInstruction(OpCodes.IFGT, label);
    }

    public static InstructionNode jumpIfLessThanOrEqualZero(LabelNode label) {
        return new JumpInstruction(OpCodes.IFLE, label);
    }

    public static InstructionNode jumpIfIntGreaterThanOrEqualZero(LabelNode label) {
        return new JumpInstruction(OpCodes.IFGE, label);
    }

    public static InstructionNode jumpIfIntEqual(LabelNode label) {
        return new JumpInstruction(OpCodes.IF_ICMPEQ, label);
    }

    public static InstructionNode jumpIfIntNotEqual(LabelNode label) {
        return new JumpInstruction(OpCodes.IF_ICMPNE, label);
    }

    public static InstructionNode jumpIfIntLessThan(LabelNode label) {
        return new JumpInstruction(OpCodes.IF_ICMPLT, label);
    }

    public static InstructionNode jumpIfIntGreaterThan(LabelNode label) {
        return new JumpInstruction(OpCodes.IF_ICMPGT, label);
    }

    public static InstructionNode jumpIfIntLessThanOrEqual(LabelNode label) {
        return new JumpInstruction(OpCodes.IF_ICMPLE, label);
    }

    public static InstructionNode jumpIfIntGreaterThanOrEqual(LabelNode label) {
        return new JumpInstruction(OpCodes.IF_ICMPGE, label);
    }

    public static InstructionNode jumpIfNull(LabelNode label) {
        return new JumpInstruction(OpCodes.IFNULL, label);
    }

    public static InstructionNode jumpIfNotNull(LabelNode label) {
        return new JumpInstruction(OpCodes.IFNONNULL, label);
    }

    public static InstructionNode jumpIfObjectSame(LabelNode label) {
        return new JumpInstruction(OpCodes.IF_ACMPEQ, label);
    }

    public static InstructionNode jumpIfObjectNotSame(LabelNode label) {
        return new JumpInstruction(OpCodes.IF_ACMPNE, label);
    }

    private JumpInstruction(OpCodes opCode, LabelNode label) {
        this.opCode = opCode;
        this.label = label;
    }

    public OpCodes getOpCode() {
        return this.opCode;
    }

    public LabelNode getLabel() {
        return this.label;
    }

    @Override
    public void accept(MethodVisitor visitor) {
        visitor.visitJumpInsn(this.opCode.getOpCode(), this.label.getLabel());
    }

    @Override
    public List<ByteCodeNode> getChildNodes() {
        return ImmutableList.of();
    }

    @Override
    public <T> T accept(ByteCodeNode parent, ByteCodeVisitor<T> visitor) {
        return visitor.visitJumpInstruction(parent, this);
    }
}

