/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.byteCode;

import com.facebook.presto.byteCode.Access;
import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.ByteCodeVisitor;
import com.facebook.presto.byteCode.Comment;
import com.facebook.presto.byteCode.CompilerContext;
import com.facebook.presto.byteCode.FieldDefinition;
import com.facebook.presto.byteCode.LocalVariableDefinition;
import com.facebook.presto.byteCode.MethodDefinition;
import com.facebook.presto.byteCode.OpCodes;
import com.facebook.presto.byteCode.ParameterizedType;
import com.facebook.presto.byteCode.debug.LineNumberNode;
import com.facebook.presto.byteCode.instruction.Constant;
import com.facebook.presto.byteCode.instruction.FieldInstruction;
import com.facebook.presto.byteCode.instruction.InvokeInstruction;
import com.facebook.presto.byteCode.instruction.JumpInstruction;
import com.facebook.presto.byteCode.instruction.LabelNode;
import com.facebook.presto.byteCode.instruction.TypeInstruction;
import com.facebook.presto.byteCode.instruction.VariableInstruction;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;
import org.objectweb.asm.MethodVisitor;

@NotThreadSafe
public class Block
implements ByteCodeNode {
    private final CompilerContext context;
    private final List<ByteCodeNode> nodes = new ArrayList<ByteCodeNode>();
    private String description;

    public Block(CompilerContext context) {
        this.context = context;
    }

    public String getDescription() {
        return this.description;
    }

    public Block setDescription(String description) {
        this.description = description;
        return this;
    }

    @Override
    public List<ByteCodeNode> getChildNodes() {
        return ImmutableList.copyOf(this.nodes);
    }

    public Block append(ByteCodeNode node) {
        if (!(node == OpCodes.NOP || node instanceof Block && ((Block)node).isEmpty())) {
            this.nodes.add(node);
        }
        return this;
    }

    public Block comment(String comment) {
        this.nodes.add(new Comment(comment));
        return this;
    }

    public Block comment(String comment, Object ... args) {
        this.nodes.add(new Comment(String.format(comment, args)));
        return this;
    }

    public boolean isEmpty() {
        return this.nodes.size() == 0;
    }

    public Block visitLabel(LabelNode label) {
        this.nodes.add(label);
        return this;
    }

    public Block gotoLabel(LabelNode label) {
        this.nodes.add(JumpInstruction.jump(label));
        return this;
    }

    public Block ifFalseGoto(LabelNode label) {
        return this.ifZeroGoto(label);
    }

    public Block ifTrueGoto(LabelNode label) {
        return this.ifNotZeroGoto(label);
    }

    public Block ifZeroGoto(LabelNode label) {
        this.nodes.add(JumpInstruction.jumpIfEqualZero(label));
        return this;
    }

    public Block ifNotZeroGoto(LabelNode label) {
        this.nodes.add(JumpInstruction.jumpIfNotEqualZero(label));
        return this;
    }

    public Block ifNullGoto(LabelNode label) {
        this.nodes.add(JumpInstruction.jumpIfNull(label));
        return this;
    }

    public Block ifNotNullGoto(LabelNode label) {
        this.nodes.add(JumpInstruction.jumpIfNotNull(label));
        return this;
    }

    public Block intLeftShift() {
        this.nodes.add(OpCodes.ISHL);
        return this;
    }

    public Block intRightShift() {
        this.nodes.add(OpCodes.ISHR);
        return this;
    }

    public Block longLeftShift() {
        this.nodes.add(OpCodes.LSHL);
        return this;
    }

    public Block longRightShift() {
        this.nodes.add(OpCodes.LSHR);
        return this;
    }

    public Block unsignedIntRightShift() {
        this.nodes.add(OpCodes.IUSHR);
        return this;
    }

    public Block unsignedLongRightShift() {
        this.nodes.add(OpCodes.LUSHR);
        return this;
    }

    public Block intBitAnd() {
        this.nodes.add(OpCodes.IAND);
        return this;
    }

    public Block intBitOr() {
        this.nodes.add(OpCodes.IOR);
        return this;
    }

    public Block intBitXor() {
        this.nodes.add(OpCodes.IXOR);
        return this;
    }

    public Block longBitAnd() {
        this.nodes.add(OpCodes.LAND);
        return this;
    }

    public Block longBitOr() {
        this.nodes.add(OpCodes.LOR);
        return this;
    }

    public Block longBitXor() {
        this.nodes.add(OpCodes.LXOR);
        return this;
    }

    public Block intNegate() {
        this.nodes.add(OpCodes.INEG);
        return this;
    }

    public Block longNegate() {
        this.nodes.add(OpCodes.LNEG);
        return this;
    }

    public Block longToInt() {
        this.nodes.add(OpCodes.L2I);
        return this;
    }

    public Block isInstanceOf(Class<?> type) {
        this.nodes.add(TypeInstruction.instanceOf(type));
        return this;
    }

    public Block isInstanceOf(ParameterizedType type) {
        this.nodes.add(TypeInstruction.instanceOf(type));
        return this;
    }

    public Block checkCast(Class<?> type) {
        this.nodes.add(TypeInstruction.cast(type));
        return this;
    }

    public Block checkCast(ParameterizedType type) {
        this.nodes.add(TypeInstruction.cast(type));
        return this;
    }

    public Block invokeStatic(Method method) {
        this.nodes.add(InvokeInstruction.invokeStatic(method));
        return this;
    }

    public Block invokeStatic(MethodDefinition method) {
        this.nodes.add(InvokeInstruction.invokeStatic(method));
        return this;
    }

    public Block invokeStatic(Class<?> type, String name, Class<?> returnType, Class<?> ... parameterTypes) {
        this.nodes.add(InvokeInstruction.invokeStatic(type, name, returnType, parameterTypes));
        return this;
    }

    public Block invokeStatic(Class<?> type, String name, Class<?> returnType, Iterable<Class<?>> parameterTypes) {
        this.nodes.add(InvokeInstruction.invokeStatic(type, name, returnType, parameterTypes));
        return this;
    }

    public Block invokeStatic(ParameterizedType type, String name, ParameterizedType returnType, ParameterizedType ... parameterTypes) {
        this.nodes.add(InvokeInstruction.invokeStatic(type, name, returnType, parameterTypes));
        return this;
    }

    public Block invokeStatic(ParameterizedType type, String name, ParameterizedType returnType, Iterable<ParameterizedType> parameterTypes) {
        this.nodes.add(InvokeInstruction.invokeStatic(type, name, returnType, parameterTypes));
        return this;
    }

    public Block invokeVirtual(Method method) {
        this.nodes.add(InvokeInstruction.invokeVirtual(method));
        return this;
    }

    public Block invokeVirtual(MethodDefinition method) {
        this.nodes.add(InvokeInstruction.invokeVirtual(method));
        return this;
    }

    public Block invokeVirtual(Class<?> type, String name, Class<?> returnType, Class<?> ... parameterTypes) {
        this.nodes.add(InvokeInstruction.invokeVirtual(type, name, returnType, parameterTypes));
        return this;
    }

    public Block invokeVirtual(Class<?> type, String name, Class<?> returnType, Iterable<Class<?>> parameterTypes) {
        this.nodes.add(InvokeInstruction.invokeVirtual(type, name, returnType, parameterTypes));
        return this;
    }

    public Block invokeVirtual(ParameterizedType type, String name, ParameterizedType returnType, ParameterizedType ... parameterTypes) {
        this.nodes.add(InvokeInstruction.invokeVirtual(type, name, returnType, parameterTypes));
        return this;
    }

    public Block invokeVirtual(ParameterizedType type, String name, ParameterizedType returnType, Iterable<ParameterizedType> parameterTypes) {
        this.nodes.add(InvokeInstruction.invokeVirtual(type, name, returnType, parameterTypes));
        return this;
    }

    public Block invokeInterface(Method method) {
        this.nodes.add(InvokeInstruction.invokeInterface(method));
        return this;
    }

    public Block invokeInterface(MethodDefinition method) {
        this.nodes.add(InvokeInstruction.invokeInterface(method));
        return this;
    }

    public Block invokeInterface(Class<?> type, String name, Class<?> returnType, Class<?> ... parameterTypes) {
        this.nodes.add(InvokeInstruction.invokeInterface(type, name, returnType, parameterTypes));
        return this;
    }

    public Block invokeInterface(Class<?> type, String name, Class<?> returnType, Iterable<Class<?>> parameterTypes) {
        this.nodes.add(InvokeInstruction.invokeInterface(type, name, returnType, parameterTypes));
        return this;
    }

    public Block invokeInterface(ParameterizedType type, String name, ParameterizedType returnType, ParameterizedType ... parameterTypes) {
        this.nodes.add(InvokeInstruction.invokeInterface(type, name, returnType, parameterTypes));
        return this;
    }

    public Block invokeInterface(ParameterizedType type, String name, ParameterizedType returnType, Iterable<ParameterizedType> parameterTypes) {
        this.nodes.add(InvokeInstruction.invokeInterface(type, name, returnType, parameterTypes));
        return this;
    }

    public Block invokeConstructor(Constructor<?> constructor) {
        this.nodes.add(InvokeInstruction.invokeConstructor(constructor));
        return this;
    }

    public Block invokeConstructor(Class<?> type, Class<?> ... parameterTypes) {
        this.nodes.add(InvokeInstruction.invokeConstructor(type, parameterTypes));
        return this;
    }

    public Block invokeConstructor(Class<?> type, Iterable<Class<?>> parameterTypes) {
        this.nodes.add(InvokeInstruction.invokeConstructor(type, parameterTypes));
        return this;
    }

    public Block invokeConstructor(ParameterizedType type, ParameterizedType ... parameterTypes) {
        this.nodes.add(InvokeInstruction.invokeConstructor(type, parameterTypes));
        return this;
    }

    public Block invokeConstructor(ParameterizedType type, Iterable<ParameterizedType> parameterTypes) {
        this.nodes.add(InvokeInstruction.invokeConstructor(type, parameterTypes));
        return this;
    }

    public Block invokeSpecial(Method method) {
        this.nodes.add(InvokeInstruction.invokeSpecial(method));
        return this;
    }

    public Block invokeSpecial(MethodDefinition method) {
        this.nodes.add(InvokeInstruction.invokeSpecial(method));
        return this;
    }

    public Block invokeSpecial(Class<?> type, String name, Class<?> returnType, Class<?> ... parameterTypes) {
        this.nodes.add(InvokeInstruction.invokeSpecial(type, name, returnType, parameterTypes));
        return this;
    }

    public Block invokeSpecial(Class<?> type, String name, Class<?> returnType, Iterable<Class<?>> parameterTypes) {
        this.nodes.add(InvokeInstruction.invokeSpecial(type, name, returnType, parameterTypes));
        return this;
    }

    public Block invokeSpecial(ParameterizedType type, String name, ParameterizedType returnType, ParameterizedType ... parameterTypes) {
        this.nodes.add(InvokeInstruction.invokeSpecial(type, name, returnType, parameterTypes));
        return this;
    }

    public Block invokeSpecial(ParameterizedType type, String name, ParameterizedType returnType, Iterable<ParameterizedType> parameterTypes) {
        this.nodes.add(InvokeInstruction.invokeSpecial(type, name, returnType, parameterTypes));
        return this;
    }

    public Block invokeDynamic(String name, Class<?> returnType, List<Class<?>> parameterTypes) {
        return this.invokeDynamic(name, MethodType.methodType(returnType, parameterTypes));
    }

    public Block invokeDynamic(String name, Class<?> returnType, Class<?> ... parameterTypes) {
        return this.invokeDynamic(name, MethodType.methodType(returnType, ImmutableList.copyOf((Object[])parameterTypes)));
    }

    public Block invokeDynamic(String name, MethodType methodType) {
        return this.invokeDynamic(name, methodType, this.context.getDefaultBootstrapMethod(), this.context.getDefaultBootstrapArguments());
    }

    public Block invokeDynamic(String name, MethodType methodType, Object ... defaultBootstrapArguments) {
        this.nodes.add(InvokeInstruction.invokeDynamic(name, methodType, this.context.getDefaultBootstrapMethod(), defaultBootstrapArguments));
        return this;
    }

    public Block invokeDynamic(String name, MethodType methodType, Method bootstrapMethod, Object ... defaultBootstrapArguments) {
        this.nodes.add(InvokeInstruction.invokeDynamic(name, methodType, bootstrapMethod, defaultBootstrapArguments));
        return this;
    }

    public Block ret() {
        this.nodes.add(OpCodes.RETURN);
        return this;
    }

    public Block retObject() {
        this.nodes.add(OpCodes.ARETURN);
        return this;
    }

    public Block retBoolean() {
        this.nodes.add(OpCodes.IRETURN);
        return this;
    }

    public Block retLong() {
        this.nodes.add(OpCodes.LRETURN);
        return this;
    }

    public Block retInt() {
        this.nodes.add(OpCodes.IRETURN);
        return this;
    }

    public Block throwObject() {
        this.nodes.add(OpCodes.ATHROW);
        return this;
    }

    public Block newObject(Class<?> type) {
        this.nodes.add(TypeInstruction.newObject(type));
        return this;
    }

    public Block newObject(ParameterizedType type) {
        this.nodes.add(TypeInstruction.newObject(type));
        return this;
    }

    public Block newArray(Class<?> type) {
        this.nodes.add(TypeInstruction.newObjectArray(type));
        return this;
    }

    public Block dup() {
        this.nodes.add(OpCodes.DUP);
        return this;
    }

    public Block dup(Class<?> type) {
        if (type == Long.TYPE || type == Double.TYPE) {
            this.nodes.add(OpCodes.DUP2);
        } else {
            this.nodes.add(OpCodes.DUP);
        }
        return this;
    }

    public Block pop() {
        this.nodes.add(OpCodes.POP);
        return this;
    }

    public Block pop(Class<?> type) {
        if (type == Long.TYPE || type == Double.TYPE) {
            this.nodes.add(OpCodes.POP2);
        } else if (type != Void.TYPE) {
            this.nodes.add(OpCodes.POP);
        }
        return this;
    }

    public Block swap() {
        this.nodes.add(OpCodes.SWAP);
        return this;
    }

    public Block getField(Field field) {
        return this.getField(field.getDeclaringClass(), field.getName(), field.getType());
    }

    public Block getField(FieldDefinition field) {
        this.getField(field.getDeclaringClass().getType(), field.getName(), field.getType());
        return this;
    }

    public Block getField(Class<?> target, String fieldName, Class<?> fieldType) {
        this.getField(ParameterizedType.type(target), fieldName, ParameterizedType.type(fieldType));
        return this;
    }

    public Block getField(ParameterizedType target, String fieldName, ParameterizedType fieldType) {
        this.nodes.add(FieldInstruction.getFieldInstruction(target, fieldName, fieldType));
        return this;
    }

    public Block putField(Field field) {
        return this.putField(field.getDeclaringClass(), field.getName(), field.getType());
    }

    public Block putField(Class<?> target, String fieldName, Class<?> fieldType) {
        this.putField(ParameterizedType.type(target), fieldName, ParameterizedType.type(fieldType));
        return this;
    }

    public Block putField(FieldDefinition field) {
        Preconditions.checkArgument((!field.getAccess().contains((Object)Access.STATIC) ? 1 : 0) != 0, (String)"Field is static: %s", (Object[])new Object[]{field});
        this.putField(field.getDeclaringClass().getType(), field.getName(), field.getType());
        return this;
    }

    public Block putField(ParameterizedType target, String fieldName, ParameterizedType fieldType) {
        this.nodes.add(FieldInstruction.putFieldInstruction(target, fieldName, fieldType));
        return this;
    }

    public Block getStaticField(FieldDefinition field) {
        this.getStaticField(field.getDeclaringClass().getType(), field.getName(), field.getType());
        return this;
    }

    public Block getStaticField(Field field) {
        Preconditions.checkArgument((boolean)Modifier.isStatic(field.getModifiers()), (String)"Field is not static: %s", (Object[])new Object[]{field});
        this.getStaticField(ParameterizedType.type(field.getDeclaringClass()), field.getName(), ParameterizedType.type(field.getType()));
        return this;
    }

    public Block getStaticField(Class<?> target, String fieldName, Class<?> fieldType) {
        this.nodes.add(FieldInstruction.getStaticInstruction(target, fieldName, fieldType));
        return this;
    }

    public Block getStaticField(ParameterizedType target, String fieldName, ParameterizedType fieldType) {
        this.nodes.add(FieldInstruction.getStaticInstruction(target, fieldName, fieldType));
        return this;
    }

    public Block getStaticField(ParameterizedType target, FieldDefinition field) {
        this.nodes.add(FieldInstruction.getStaticInstruction(target, field.getName(), field.getType()));
        return this;
    }

    public Block putStaticField(FieldDefinition field) {
        this.putStaticField(field.getDeclaringClass().getType(), field.getName(), field.getType());
        return this;
    }

    public Block putStaticField(ParameterizedType target, FieldDefinition field) {
        Preconditions.checkArgument((boolean)field.getAccess().contains((Object)Access.STATIC), (String)"Field is not static: %s", (Object[])new Object[]{field});
        this.putStaticField(target, field.getName(), field.getType());
        return this;
    }

    public Block putStaticField(ParameterizedType target, String fieldName, ParameterizedType fieldType) {
        this.nodes.add(FieldInstruction.putStaticInstruction(target, fieldName, fieldType));
        return this;
    }

    public Block pushThis() {
        this.getVariable("this");
        return this;
    }

    public Block pushNull() {
        this.nodes.add(OpCodes.ACONST_NULL);
        return this;
    }

    public Block push(Class<?> type) {
        this.nodes.add(Constant.loadClass(type));
        return this;
    }

    public Block push(ParameterizedType type) {
        this.nodes.add(Constant.loadClass(type));
        return this;
    }

    public Block push(String value) {
        this.nodes.add(Constant.loadString(value));
        return this;
    }

    public Block push(Number value) {
        this.nodes.add(Constant.loadNumber(value));
        return this;
    }

    public Block push(int value) {
        this.nodes.add(Constant.loadInt(value));
        return this;
    }

    public Block push(boolean value) {
        this.nodes.add(Constant.loadBoolean(value));
        return this;
    }

    public Block pushJavaDefault(Class<?> type) {
        if (type == Void.TYPE) {
            return this;
        }
        if (type == Boolean.TYPE || type == Byte.TYPE || type == Character.TYPE || type == Short.TYPE || type == Integer.TYPE) {
            return this.push(0);
        }
        if (type == Long.TYPE) {
            return this.push(0L);
        }
        if (type == Float.TYPE) {
            return this.push(Float.valueOf(0.0f));
        }
        if (type == Double.TYPE) {
            return this.push(0.0);
        }
        return this.pushNull();
    }

    public Block getVariable(String name) {
        this.append(this.context.getVariable(name).getValue());
        return this;
    }

    public Block getVariable(String name, ParameterizedType type) {
        this.getVariable(name);
        this.checkCast(type);
        return this;
    }

    public Block initializeVariable(LocalVariableDefinition variable) {
        ParameterizedType type = variable.getType();
        if (type.getType().length() == 1) {
            switch (type.getType().charAt(0)) {
                case 'B': 
                case 'C': 
                case 'I': 
                case 'S': 
                case 'Z': {
                    this.nodes.add(Constant.loadInt(0));
                    break;
                }
                case 'F': {
                    this.nodes.add(Constant.loadFloat(0.0f));
                    break;
                }
                case 'D': {
                    this.nodes.add(Constant.loadDouble(0.0));
                    break;
                }
                case 'J': {
                    this.nodes.add(Constant.loadLong(0L));
                    break;
                }
                default: {
                    Preconditions.checkArgument((boolean)false, (String)"Unknown type '%s'", (Object[])new Object[]{variable.getType()});
                    break;
                }
            }
        } else {
            this.nodes.add(Constant.loadNull());
        }
        this.nodes.add(VariableInstruction.storeVariable(variable));
        return this;
    }

    public Block getVariable(LocalVariableDefinition variable) {
        this.nodes.add(VariableInstruction.loadVariable(variable));
        return this;
    }

    public Block putVariable(String name) {
        this.append(this.context.getVariable(name).setValue());
        return this;
    }

    public Block putVariable(String name, Class<?> type) {
        this.nodes.add(Constant.loadClass(type));
        this.putVariable(name);
        return this;
    }

    public Block putVariable(String name, ParameterizedType type) {
        this.nodes.add(Constant.loadClass(type));
        this.putVariable(name);
        return this;
    }

    public Block putVariable(String name, String value) {
        this.nodes.add(Constant.loadString(value));
        this.putVariable(name);
        return this;
    }

    public Block putVariable(String name, Number value) {
        this.nodes.add(Constant.loadNumber(value));
        this.putVariable(name);
        return this;
    }

    public Block putVariable(String name, int value) {
        this.nodes.add(Constant.loadInt(value));
        this.putVariable(name);
        return this;
    }

    public Block putVariable(String name, boolean value) {
        this.nodes.add(Constant.loadBoolean(value));
        this.putVariable(name);
        return this;
    }

    public Block putVariable(LocalVariableDefinition variable) {
        this.nodes.add(VariableInstruction.storeVariable(variable));
        return this;
    }

    public Block putVariable(LocalVariableDefinition variable, Class<?> type) {
        this.nodes.add(Constant.loadClass(type));
        this.putVariable(variable);
        return this;
    }

    public Block putVariable(LocalVariableDefinition variable, ParameterizedType type) {
        this.nodes.add(Constant.loadClass(type));
        this.putVariable(variable);
        return this;
    }

    public Block putVariable(LocalVariableDefinition variable, String value) {
        this.nodes.add(Constant.loadString(value));
        this.putVariable(variable);
        return this;
    }

    public Block putVariable(LocalVariableDefinition variable, Number value) {
        this.nodes.add(Constant.loadNumber(value));
        this.putVariable(variable);
        return this;
    }

    public Block putVariable(LocalVariableDefinition variable, int value) {
        this.nodes.add(Constant.loadInt(value));
        this.putVariable(variable);
        return this;
    }

    public Block putVariable(LocalVariableDefinition variable, boolean value) {
        this.nodes.add(Constant.loadBoolean(value));
        this.putVariable(variable);
        return this;
    }

    public Block incrementVariable(LocalVariableDefinition variable, byte increment) {
        String type = variable.getType().getClassName();
        Preconditions.checkArgument((boolean)ImmutableList.of((Object)"byte", (Object)"short", (Object)"int").contains((Object)type), (String)"variable must be an byte, short or int, but is %s", (Object[])new Object[]{type});
        this.nodes.add(VariableInstruction.incrementVariable(variable, increment));
        return this;
    }

    public Block getObjectArrayElement() {
        this.nodes.add(OpCodes.AALOAD);
        return this;
    }

    public Block putObjectArrayElement() {
        this.nodes.add(OpCodes.AASTORE);
        return this;
    }

    public Block visitLineNumber(int line) {
        if (line <= 0) {
            this.context.cleanLineNumber();
        } else if (!this.context.hasVisitedLine(line)) {
            this.nodes.add(new LineNumberNode(line));
            this.context.visitLine(line);
        }
        return this;
    }

    @Override
    public void accept(MethodVisitor visitor) {
        for (ByteCodeNode node : this.nodes) {
            node.accept(visitor);
        }
    }

    @Override
    public <T> T accept(ByteCodeNode parent, ByteCodeVisitor<T> visitor) {
        return visitor.visitBlock(parent, this);
    }
}

