/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.block;

import com.facebook.presto.block.Block;
import com.facebook.presto.block.BlockCursor;
import com.facebook.presto.block.BlockIterable;
import com.facebook.presto.tuple.Tuple;
import com.facebook.presto.tuple.TupleInfo;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import io.airlift.units.DataSize;
import java.util.Iterator;

public class BlockUtils {
    public static BlockIterable emptyBlockIterable() {
        return new BlockIterable(){

            @Override
            public TupleInfo getTupleInfo() {
                return TupleInfo.SINGLE_LONG;
            }

            @Override
            public Optional<DataSize> getDataSize() {
                return Optional.of((Object)new DataSize(0.0, DataSize.Unit.BYTE));
            }

            @Override
            public Optional<Integer> getPositionCount() {
                return Optional.of((Object)0);
            }

            @Override
            public Iterator<Block> iterator() {
                return Iterators.emptyIterator();
            }
        };
    }

    public static BlockIterable toBlocks(Block firstBlock, Block ... rest) {
        return new BlocksIterableAdapter(firstBlock.getTupleInfo(), (Optional<DataSize>)Optional.absent(), (Optional<Integer>)Optional.absent(), (Iterable<Block>)ImmutableList.builder().add((Object)firstBlock).add((Object[])rest).build());
    }

    public static BlockIterable toBlocks(Iterable<Block> blocks) {
        return new BlocksIterableAdapter(((Block)Iterables.get(blocks, (int)0)).getTupleInfo(), (Optional<DataSize>)Optional.absent(), (Optional<Integer>)Optional.absent(), blocks);
    }

    public static BlockIterable toBlocks(DataSize dataSize, int positionCount, Iterable<Block> blocks) {
        return new BlocksIterableAdapter(((Block)Iterables.get(blocks, (int)0)).getTupleInfo(), (Optional<DataSize>)Optional.of((Object)dataSize), (Optional<Integer>)Optional.of((Object)positionCount), blocks);
    }

    public static Iterable<Tuple> toTupleIterable(Block block) {
        Preconditions.checkNotNull((Object)block, (Object)"block is null");
        return new BlockIterableAdapter(block);
    }

    public static Iterator<Tuple> toTupleIterable(BlockCursor cursor) {
        return new BlockCursorIteratorAdapter(cursor);
    }

    private static class BlockCursorIteratorAdapter
    extends AbstractIterator<Tuple> {
        private final BlockCursor cursor;

        private BlockCursorIteratorAdapter(BlockCursor cursor) {
            this.cursor = cursor;
        }

        protected Tuple computeNext() {
            if (!this.cursor.advanceNextPosition()) {
                return (Tuple)this.endOfData();
            }
            return this.cursor.getTuple();
        }
    }

    private static class BlockIterableAdapter
    implements Iterable<Tuple> {
        private final Block block;

        private BlockIterableAdapter(Block block) {
            this.block = block;
        }

        @Override
        public Iterator<Tuple> iterator() {
            return new BlockCursorIteratorAdapter(this.block.cursor());
        }
    }

    private static class BlocksIterableAdapter
    implements BlockIterable {
        private final TupleInfo tupleInfo;
        private final Iterable<Block> blocks;
        private Optional<DataSize> dataSize;
        private final Optional<Integer> positionCount;

        public BlocksIterableAdapter(TupleInfo tupleInfo, Iterable<Block> blocks) {
            this(tupleInfo, (Optional<DataSize>)Optional.absent(), (Optional<Integer>)Optional.absent(), blocks);
        }

        public BlocksIterableAdapter(TupleInfo tupleInfo, Optional<DataSize> dataSize, Optional<Integer> positionCount, Iterable<Block> blocks) {
            this.tupleInfo = tupleInfo;
            this.blocks = blocks;
            this.dataSize = dataSize;
            this.positionCount = positionCount;
        }

        @Override
        public TupleInfo getTupleInfo() {
            return this.tupleInfo;
        }

        @Override
        public Optional<DataSize> getDataSize() {
            return this.dataSize;
        }

        @Override
        public Optional<Integer> getPositionCount() {
            return this.positionCount;
        }

        @Override
        public Iterator<Block> iterator() {
            return this.blocks.iterator();
        }
    }
}

