/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.block;

import com.facebook.presto.block.uncompressed.UncompressedBlock;
import com.facebook.presto.tuple.TupleInfo;
import com.facebook.presto.tuple.TupleReadable;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import java.nio.charset.Charset;

public class BlockBuilder {
    public static final DataSize DEFAULT_MAX_BLOCK_SIZE = new DataSize(64.0, DataSize.Unit.KILOBYTE);
    public static final double DEFAULT_STORAGE_MULTIPLIER = 1.2;
    private final TupleInfo tupleInfo;
    private final int maxBlockSize;
    private final SliceOutput sliceOutput;
    private int count;
    private TupleInfo.Builder tupleBuilder;

    public BlockBuilder(TupleInfo tupleInfo) {
        this(tupleInfo, DEFAULT_MAX_BLOCK_SIZE, 1.2);
    }

    public BlockBuilder(TupleInfo tupleInfo, DataSize blockSize, double storageMultiplier) {
        this(tupleInfo, (int)((DataSize)Preconditions.checkNotNull((Object)blockSize, (Object)"blockSize is null")).toBytes(), (SliceOutput)new DynamicSliceOutput((int)((double)((int)blockSize.toBytes()) * storageMultiplier)));
    }

    public BlockBuilder(TupleInfo tupleInfo, int maxBlockSize, SliceOutput sliceOutput) {
        Preconditions.checkNotNull((Object)maxBlockSize, (Object)"maxBlockSize is null");
        Preconditions.checkNotNull((Object)tupleInfo, (Object)"tupleInfo is null");
        this.tupleInfo = tupleInfo;
        this.maxBlockSize = maxBlockSize;
        this.sliceOutput = sliceOutput;
        this.tupleBuilder = tupleInfo.builder(this.sliceOutput);
    }

    public TupleInfo getTupleInfo() {
        return this.tupleInfo;
    }

    public boolean isEmpty() {
        Preconditions.checkState((!this.tupleBuilder.isPartial() ? 1 : 0) != 0, (Object)"Tuple is not complete");
        return this.count == 0;
    }

    public boolean isFull() {
        Preconditions.checkState((!this.tupleBuilder.isPartial() ? 1 : 0) != 0, (Object)"Tuple is not complete");
        return this.sliceOutput.size() > this.maxBlockSize;
    }

    public int size() {
        return this.sliceOutput.size();
    }

    public int writableBytes() {
        return this.maxBlockSize - this.sliceOutput.size();
    }

    public BlockBuilder append(boolean value) {
        this.tupleBuilder.append(value);
        this.flushTupleIfNecessary();
        return this;
    }

    public BlockBuilder append(long value) {
        this.tupleBuilder.append(value);
        this.flushTupleIfNecessary();
        return this;
    }

    public BlockBuilder append(double value) {
        this.tupleBuilder.append(value);
        this.flushTupleIfNecessary();
        return this;
    }

    public BlockBuilder append(byte[] value) {
        return this.append(Slices.wrappedBuffer((byte[])value));
    }

    public BlockBuilder append(String value) {
        return this.append(Slices.copiedBuffer((String)value, (Charset)Charsets.UTF_8));
    }

    public BlockBuilder append(Slice value) {
        this.tupleBuilder.append(value);
        this.flushTupleIfNecessary();
        return this;
    }

    public BlockBuilder appendNull() {
        this.tupleBuilder.appendNull();
        this.flushTupleIfNecessary();
        return this;
    }

    public BlockBuilder append(TupleReadable tuple) {
        this.tupleBuilder.append(tuple);
        this.flushTupleIfNecessary();
        return this;
    }

    public BlockBuilder append(TupleReadable tuple, int index) {
        this.tupleBuilder.append(tuple, index);
        this.flushTupleIfNecessary();
        return this;
    }

    public BlockBuilder appendTuple(Slice slice, int offset) {
        Preconditions.checkState((!this.tupleBuilder.isPartial() ? 1 : 0) != 0, (Object)"Tuple is not complete");
        int length = this.tupleInfo.size(slice, offset);
        return this.appendTuple(slice, offset, length);
    }

    public BlockBuilder appendTuple(Slice slice, int offset, int length) {
        Preconditions.checkState((!this.tupleBuilder.isPartial() ? 1 : 0) != 0, (Object)"Tuple is not complete");
        this.sliceOutput.writeBytes(slice, offset, length);
        ++this.count;
        return this;
    }

    private void flushTupleIfNecessary() {
        if (this.tupleBuilder.isComplete()) {
            this.tupleBuilder.finish();
            ++this.count;
        }
    }

    public UncompressedBlock build() {
        Preconditions.checkState((!this.tupleBuilder.isPartial() ? 1 : 0) != 0, (Object)"Tuple is not complete");
        Preconditions.checkState((!this.isEmpty() ? 1 : 0) != 0, (Object)"Cannot build an empty block");
        return new UncompressedBlock(this.count, this.tupleInfo, this.sliceOutput.slice());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("BlockBuilder");
        sb.append("{count=").append(this.count);
        sb.append(", size=").append(this.sliceOutput.size());
        sb.append(", maxSize=").append(this.maxBlockSize);
        sb.append(", tupleInfo=").append(this.tupleInfo);
        sb.append('}');
        return sb.toString();
    }
}

