/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto;

import com.facebook.presto.PagePartitionFunction;
import com.facebook.presto.block.Block;
import com.facebook.presto.block.BlockCursor;
import com.facebook.presto.operator.Page;
import com.facebook.presto.operator.PageBuilder;
import com.facebook.presto.tuple.TupleInfo;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import java.util.ArrayList;
import java.util.List;

public final class HashPagePartitionFunction
implements PagePartitionFunction {
    private final int partition;
    private final int partitionCount;
    private final int partitioningChannel;

    @JsonCreator
    public HashPagePartitionFunction(@JsonProperty(value="partition") int partition, @JsonProperty(value="partitionCount") int partitionCount, @JsonProperty(value="partitioningChannel") int partitioningChannel) {
        this.partition = partition;
        this.partitionCount = partitionCount;
        this.partitioningChannel = partitioningChannel;
    }

    @JsonProperty
    public int getPartition() {
        return this.partition;
    }

    @JsonProperty
    public int getPartitionCount() {
        return this.partitionCount;
    }

    @JsonProperty
    public int getPartitioningChannel() {
        return this.partitioningChannel;
    }

    @Override
    public List<Page> partition(List<Page> pages) {
        if (pages.isEmpty()) {
            return pages;
        }
        List<TupleInfo> tupleInfos = HashPagePartitionFunction.getTupleInfos(pages);
        PageBuilder pageBuilder = new PageBuilder(tupleInfos);
        ImmutableList.Builder partitionedPages = ImmutableList.builder();
        for (Page page : pages) {
            BlockCursor[] cursors = new BlockCursor[tupleInfos.size()];
            for (int i = 0; i < cursors.length; ++i) {
                cursors[i] = page.getBlock(i).cursor();
            }
            for (int position = 0; position < page.getPositionCount(); ++position) {
                for (BlockCursor cursor : cursors) {
                    cursor.advanceNextPosition();
                }
                int partitionHashBucket = this.getPartitionHashBucket(tupleInfos, cursors);
                if (partitionHashBucket != this.partition) continue;
                for (int channel = 0; channel < cursors.length; ++channel) {
                    pageBuilder.getBlockBuilder(channel).append(cursors[channel]);
                }
                if (!pageBuilder.isFull()) continue;
                partitionedPages.add((Object)pageBuilder.build());
                pageBuilder.reset();
            }
        }
        if (!pageBuilder.isEmpty()) {
            partitionedPages.add((Object)pageBuilder.build());
        }
        return partitionedPages.build();
    }

    private int getPartitionHashBucket(List<TupleInfo> tupleInfos, BlockCursor[] cursors) {
        long hashCode = (long)this.getPartitionedHashCode(tupleInfos, cursors[this.partitioningChannel]) & 0xFFFFFFFFL;
        int bucket = (int)(hashCode % (long)this.partitionCount);
        Preconditions.checkState((bucket >= 0 && bucket < this.partitionCount ? 1 : 0) != 0);
        return bucket;
    }

    private int getPartitionedHashCode(List<TupleInfo> tupleInfos, BlockCursor partitionedCursor) {
        Slice partitionedSlice = partitionedCursor.getRawSlice();
        int partitionedOffset = partitionedCursor.getRawOffset();
        int partitionedLength = tupleInfos.get(this.partitioningChannel).size(partitionedSlice, partitionedOffset);
        return partitionedSlice.hashCode(partitionedOffset, partitionedLength);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.partition, this.partitionCount, this.partitioningChannel});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HashPagePartitionFunction other = (HashPagePartitionFunction)obj;
        return Objects.equal((Object)this.partition, (Object)other.partition) && Objects.equal((Object)this.partitionCount, (Object)other.partitionCount) && Objects.equal((Object)this.partitioningChannel, (Object)other.partitioningChannel);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("partition", this.partition).add("partitionCount", this.partitionCount).add("partitioningChannel", this.partitioningChannel).toString();
    }

    private static List<TupleInfo> getTupleInfos(List<Page> pages) {
        Page firstPage = pages.get(0);
        ArrayList<TupleInfo> tupleInfos = new ArrayList<TupleInfo>();
        for (Block block : firstPage.getBlocks()) {
            tupleInfos.add(block.getTupleInfo());
        }
        return tupleInfos;
    }
}

