/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class Threads {
    private static final Class<? extends ListeningExecutorService> GUAVA_SAME_THREAD_EXECUTOR_CLASS = MoreExecutors.sameThreadExecutor().getClass();

    public static ThreadFactory threadsNamed(String nameFormat) {
        return new ThreadFactoryBuilder().setNameFormat(nameFormat).build();
    }

    public static ThreadFactory daemonThreadsNamed(String nameFormat) {
        return new ThreadFactoryBuilder().setNameFormat(nameFormat).setDaemon(true).build();
    }

    public static Executor checkNotSameThreadExecutor(Executor executor, String name) {
        Preconditions.checkNotNull((Object)executor, (String)"%s is null", (Object[])new Object[]{name});
        Preconditions.checkArgument((!Threads.isSameThreadExecutor(executor) ? 1 : 0) != 0, (String)"%s is a same thread executor", (Object[])new Object[]{name});
        return executor;
    }

    public static boolean isSameThreadExecutor(Executor executor) {
        Preconditions.checkNotNull((Object)executor, (Object)"executor is null");
        if (executor.getClass() == GUAVA_SAME_THREAD_EXECUTOR_CLASS) {
            return true;
        }
        final Thread thisThread = Thread.currentThread();
        final SettableFuture isSameThreadExecutor = SettableFuture.create();
        executor.execute(new Runnable(){

            @Override
            public void run() {
                isSameThreadExecutor.set((Object)(thisThread == Thread.currentThread() ? 1 : 0));
            }
        });
        try {
            return (Boolean)Futures.get((Future)isSameThreadExecutor, (long)10L, (TimeUnit)TimeUnit.SECONDS, Exception.class);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw Throwables.propagate((Throwable)e);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

