/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tuple;

import com.facebook.presto.spi.ColumnType;
import com.facebook.presto.tuple.Tuple;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.primitives.Ints;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class TupleInfo {
    public static final TupleInfo SINGLE_BOOLEAN = new TupleInfo(Type.BOOLEAN);
    public static final TupleInfo SINGLE_LONG = new TupleInfo(Type.FIXED_INT_64);
    public static final TupleInfo SINGLE_VARBINARY = new TupleInfo(Type.VARIABLE_BINARY);
    public static final TupleInfo SINGLE_DOUBLE = new TupleInfo(Type.DOUBLE);
    private final int size;
    private final List<Type> types;
    private final List<Integer> offsets;
    private final int firstVariableLengthField;
    private final int secondVariableLengthField;
    private final int variableLengthFieldCount;
    private final int variablePartOffset;

    public TupleInfo(Type ... types) {
        this(Arrays.asList(types));
    }

    public TupleInfo(Iterable<Type> types) {
        this((List<Type>)ImmutableList.copyOf(types));
    }

    @JsonCreator
    public TupleInfo(List<Type> typeIterable) {
        int nullBytes;
        Preconditions.checkNotNull(typeIterable, (Object)"typeIterable is null");
        this.types = ImmutableList.copyOf(typeIterable);
        int[] offsets = new int[this.types.size() + 1];
        int currentOffset = nullBytes = (this.types.size() - 1 >> 3) + 1;
        for (int i = 0; i < this.types.size(); ++i) {
            Type type = this.types.get(i);
            if (!type.isFixedSize()) continue;
            offsets[i] = currentOffset;
            currentOffset += type.getSize();
        }
        boolean hasVariableLengthFields = false;
        int firstVariableLengthField = -1;
        int secondVariableLengthField = -1;
        int variableLengthFieldCount = 0;
        for (int i = 0; i < this.types.size(); ++i) {
            Type type = this.types.get(i);
            if (type.isFixedSize()) continue;
            ++variableLengthFieldCount;
            offsets[i] = currentOffset;
            if (hasVariableLengthFields) {
                currentOffset += 4;
                if (secondVariableLengthField == -1) {
                    secondVariableLengthField = i;
                }
            } else {
                firstVariableLengthField = i;
            }
            hasVariableLengthFields = true;
        }
        if (secondVariableLengthField == -1) {
            secondVariableLengthField = this.types.size();
        }
        offsets[offsets.length - 1] = currentOffset;
        this.size = hasVariableLengthFields ? -1 : currentOffset;
        this.firstVariableLengthField = firstVariableLengthField;
        this.secondVariableLengthField = secondVariableLengthField;
        this.variableLengthFieldCount = variableLengthFieldCount;
        this.offsets = ImmutableList.copyOf((Collection)Ints.asList((int[])offsets));
        int variablePartOffset = nullBytes;
        boolean isFirst = true;
        for (Type type : this.getTypes()) {
            if (!type.isFixedSize()) {
                if (!isFirst) {
                    variablePartOffset += 4;
                }
                isFirst = false;
                continue;
            }
            variablePartOffset += type.getSize();
        }
        this.variablePartOffset = variablePartOffset += 4;
    }

    @JsonValue
    public List<Type> getTypes() {
        return this.types;
    }

    public int getFieldCount() {
        return this.types.size();
    }

    public int getFixedSize() {
        return this.size;
    }

    public int size(Slice slice) {
        return this.size(slice, 0);
    }

    public int size(Slice slice, int offset) {
        if (this.size != -1) {
            return this.size;
        }
        return slice.getInt(offset + this.getTupleSizeOffset());
    }

    public int size(SliceInput sliceInput) {
        if (this.size != -1) {
            return this.size;
        }
        int originalPosition = sliceInput.position();
        sliceInput.skipBytes(this.getTupleSizeOffset());
        int tupleSize = sliceInput.readInt();
        sliceInput.setPosition(originalPosition);
        return tupleSize;
    }

    public boolean getBoolean(Slice slice, int field) {
        return this.getBoolean(slice, 0, field);
    }

    public boolean getBoolean(Slice slice, int offset, int field) {
        Preconditions.checkState((this.types.get(field) == Type.BOOLEAN ? 1 : 0) != 0, (String)"Expected BOOLEAN, but is %s", (Object[])new Object[]{this.types.get(field)});
        return slice.getByte(offset + this.getOffset(field)) != 0;
    }

    public void setBoolean(Slice slice, int field, boolean value) {
        this.setBoolean(slice, 0, field, value);
    }

    public void setBoolean(Slice slice, int offset, int field, boolean value) {
        Preconditions.checkState((this.types.get(field) == Type.BOOLEAN ? 1 : 0) != 0, (String)"Expected BOOLEAN, but is %s", (Object[])new Object[]{this.types.get(field)});
        slice.setByte(offset + this.getOffset(field), value ? 1 : 0);
    }

    public long getLong(Slice slice, int field) {
        return this.getLong(slice, 0, field);
    }

    public long getLong(Slice slice, int offset, int field) {
        Preconditions.checkState((this.types.get(field) == Type.FIXED_INT_64 ? 1 : 0) != 0, (String)"Expected FIXED_INT_64, but is %s", (Object[])new Object[]{this.types.get(field)});
        return slice.getLong(offset + this.getOffset(field));
    }

    public void setLong(Slice slice, int field, long value) {
        this.setLong(slice, 0, field, value);
    }

    public void setLong(Slice slice, int offset, int field, long value) {
        Preconditions.checkState((this.types.get(field) == Type.FIXED_INT_64 ? 1 : 0) != 0, (String)"Expected FIXED_INT_64, but is %s", (Object[])new Object[]{this.types.get(field)});
        slice.setLong(offset + this.getOffset(field), value);
    }

    public double getDouble(Slice slice, int field) {
        return this.getDouble(slice, 0, field);
    }

    public double getDouble(Slice slice, int offset, int field) {
        Preconditions.checkState((this.types.get(field) == Type.DOUBLE ? 1 : 0) != 0, (String)"Expected DOUBLE, but is %s", (Object[])new Object[]{this.types.get(field)});
        return slice.getDouble(offset + this.getOffset(field));
    }

    public void setDouble(Slice slice, int field, double value) {
        this.setDouble(slice, 0, field, value);
    }

    public void setDouble(Slice slice, int offset, int field, double value) {
        Preconditions.checkState((this.types.get(field) == Type.DOUBLE ? 1 : 0) != 0, (String)"Expected DOUBLE, but is %s", (Object[])new Object[]{this.types.get(field)});
        slice.setDouble(offset + this.getOffset(field), value);
    }

    public Slice getSlice(Slice slice, int field) {
        return this.getSlice(slice, 0, field);
    }

    public Slice getSlice(Slice slice, int offset, int field) {
        int end;
        int start;
        Preconditions.checkState((this.types.get(field) == Type.VARIABLE_BINARY ? 1 : 0) != 0, (String)"Expected VARIABLE_BINARY, but is %s", (Object[])new Object[]{this.types.get(field)});
        if (field == this.firstVariableLengthField) {
            start = this.variablePartOffset;
            end = slice.getInt(offset + this.getOffset(this.secondVariableLengthField));
        } else {
            start = slice.getInt(offset + this.getOffset(field));
            end = slice.getInt(offset + this.getOffset(field) + 4);
        }
        return slice.slice(offset + start, end - start);
    }

    public boolean isNull(Slice slice, int field) {
        return this.isNull(slice, 0, field);
    }

    public boolean isNull(Slice slice, int offset, int field) {
        int index = field >> 3;
        int bit = field & 7;
        int bitMask = 1 << bit;
        return (slice.getByte(offset + index) & bitMask) != 0;
    }

    public void setNull(Slice slice, int offset, int field) {
        int index = field >> 3;
        int bit = field & 7;
        int bitMask = 1 << bit;
        slice.setByte(index + offset, slice.getByte(index + offset) | bitMask);
    }

    public void setNotNull(Slice slice, int field) {
        this.setNotNull(slice, 0, field);
    }

    public void setNotNull(Slice slice, int offset, int field) {
        int index = field >> 3;
        int bit = field & 7;
        int bitMask = ~(1 << bit);
        slice.setByte(index + offset, slice.getByte(index + offset) & bitMask);
    }

    public Slice extractTupleSlice(SliceInput sliceInput) {
        int tupleSliceSize = this.size(sliceInput);
        return sliceInput.readSlice(tupleSliceSize);
    }

    public Tuple extractTuple(SliceInput sliceInput) {
        return new Tuple(this.extractTupleSlice(sliceInput), this);
    }

    public boolean equals(int field, Slice block, int tupleOffset, Slice value) {
        int end;
        int start;
        if (field == this.firstVariableLengthField) {
            start = this.variablePartOffset;
            end = block.getInt(tupleOffset + this.getOffset(this.secondVariableLengthField));
        } else {
            start = block.getInt(tupleOffset + this.getOffset(field));
            end = block.getInt(tupleOffset + this.getOffset(field) + 4);
        }
        return value.equals(0, value.length(), block, tupleOffset + start, end - start);
    }

    public int getTupleSizeOffset() {
        return this.getOffset(this.types.size());
    }

    private int getOffset(int field) {
        Preconditions.checkArgument((field != this.firstVariableLengthField ? 1 : 0) != 0, (Object)"Cannot get offset for first variable length field");
        return this.offsets.get(field);
    }

    public Builder builder(SliceOutput sliceOutput) {
        return new Builder(sliceOutput);
    }

    public Builder builder() {
        return new Builder((SliceOutput)new DynamicSliceOutput(0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TupleInfo tupleInfo = (TupleInfo)o;
        return this.types.equals(tupleInfo.types);
    }

    public int hashCode() {
        return this.types.hashCode();
    }

    public String toString() {
        return "TupleInfo{" + Joiner.on((String)",").join(this.types) + "}";
    }

    public class Builder {
        private final SliceOutput sliceOutput;
        private final List<Slice> variableLengthFields;
        private final Slice fixedBuffer;
        private int currentField;

        public Builder(SliceOutput sliceOutput) {
            this.sliceOutput = sliceOutput;
            this.variableLengthFields = new ArrayList<Slice>(TupleInfo.this.variableLengthFieldCount);
            this.fixedBuffer = Slices.allocate((int)(TupleInfo.this.size < 0 ? TupleInfo.this.getOffset(TupleInfo.this.secondVariableLengthField) : TupleInfo.this.size));
        }

        public Builder append(boolean value) {
            Preconditions.checkState((TupleInfo.this.getTypes().get(this.currentField) == Type.BOOLEAN ? 1 : 0) != 0, (String)"Cannot append boolean. Current field (%s) is of type %s", (Object[])new Object[]{this.currentField, TupleInfo.this.getTypes().get(this.currentField)});
            this.fixedBuffer.setByte(TupleInfo.this.getOffset(this.currentField), value ? 1 : 0);
            ++this.currentField;
            return this;
        }

        public Builder append(long value) {
            Preconditions.checkState((TupleInfo.this.getTypes().get(this.currentField) == Type.FIXED_INT_64 ? 1 : 0) != 0, (String)"Cannot append long. Current field (%s) is of type %s", (Object[])new Object[]{this.currentField, TupleInfo.this.getTypes().get(this.currentField)});
            this.fixedBuffer.setLong(TupleInfo.this.getOffset(this.currentField), value);
            ++this.currentField;
            return this;
        }

        public Builder append(double value) {
            Preconditions.checkState((TupleInfo.this.getTypes().get(this.currentField) == Type.DOUBLE ? 1 : 0) != 0, (String)"Cannot append double. Current field (%s) is of type %s", (Object[])new Object[]{this.currentField, TupleInfo.this.getTypes().get(this.currentField)});
            this.fixedBuffer.setDouble(TupleInfo.this.getOffset(this.currentField), value);
            ++this.currentField;
            return this;
        }

        public Builder append(String value) {
            return this.append(Slices.copiedBuffer((String)value, (Charset)Charsets.UTF_8));
        }

        public Builder append(Slice value) {
            Preconditions.checkState((TupleInfo.this.getTypes().get(this.currentField) == Type.VARIABLE_BINARY ? 1 : 0) != 0, (String)"Cannot append binary. Current field (%s) is of type %s", (Object[])new Object[]{this.currentField, TupleInfo.this.getTypes().get(this.currentField)});
            this.variableLengthFields.add(value);
            ++this.currentField;
            return this;
        }

        public Builder appendNull() {
            int index = this.currentField >> 3;
            int bit = this.currentField & 7;
            int bitMask = 1 << bit;
            this.fixedBuffer.setByte(index, this.fixedBuffer.getByte(index) | bitMask);
            if (TupleInfo.this.getTypes().get(this.currentField) == Type.VARIABLE_BINARY) {
                this.variableLengthFields.add(null);
            }
            ++this.currentField;
            return this;
        }

        public Builder append(Tuple tuple) {
            for (int field = 0; field < tuple.getTupleInfo().getFieldCount(); ++field) {
                this.append(tuple, field);
            }
            return this;
        }

        public Builder append(Tuple tuple, int index) {
            Type type = TupleInfo.this.getTypes().get(this.currentField);
            Preconditions.checkArgument((type == tuple.getTupleInfo().getTypes().get(index) ? 1 : 0) != 0, (String)"Current field (%s) type (%s) does not match tuple field (%s) type (%s)", (Object[])new Object[]{this.currentField, type, index, tuple.getTupleInfo().getTypes().get(index)});
            if (tuple.isNull(index)) {
                this.appendNull();
            } else {
                switch (type) {
                    case BOOLEAN: {
                        this.append(tuple.getBoolean(index));
                        break;
                    }
                    case FIXED_INT_64: {
                        this.append(tuple.getLong(index));
                        break;
                    }
                    case DOUBLE: {
                        this.append(tuple.getDouble(index));
                        break;
                    }
                    case VARIABLE_BINARY: {
                        this.append(tuple.getSlice(index));
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Type not yet supported: " + type);
                    }
                }
            }
            return this;
        }

        public boolean isComplete() {
            return this.currentField == TupleInfo.this.types.size();
        }

        public boolean isPartial() {
            return this.currentField > 0 && !this.isComplete();
        }

        public void finish() {
            Preconditions.checkState((boolean)this.isComplete(), (Object)"Tuple is incomplete");
            this.sliceOutput.writeBytes(this.fixedBuffer);
            boolean isFirst = true;
            int offset = TupleInfo.this.variablePartOffset;
            for (Slice field : this.variableLengthFields) {
                if (!isFirst) {
                    this.sliceOutput.writeInt(offset);
                }
                if (field != null) {
                    offset += field.length();
                }
                isFirst = false;
            }
            if (!this.variableLengthFields.isEmpty()) {
                this.sliceOutput.writeInt(offset);
            }
            for (Slice field : this.variableLengthFields) {
                if (field == null) continue;
                this.sliceOutput.writeBytes(field);
            }
            this.currentField = 0;
            this.variableLengthFields.clear();
            this.fixedBuffer.clear();
        }

        public Tuple build() {
            this.finish();
            return new Tuple(this.sliceOutput.slice(), TupleInfo.this);
        }
    }

    public static enum Type implements Comparable<Type>
    {
        FIXED_INT_64(8, "bigint"),
        VARIABLE_BINARY(-1, "varchar"),
        DOUBLE(8, "double"),
        BOOLEAN(1, "boolean");

        private static final Map<String, Type> NAMES;
        private final int size;
        private final String name;

        private Type(int size, String name) {
            this.size = size;
            this.name = name;
        }

        int getSize() {
            Preconditions.checkState((boolean)this.isFixedSize(), (Object)"Can't get size of variable length field");
            return this.size;
        }

        boolean isFixedSize() {
            return this.size != -1;
        }

        @JsonValue
        public String getName() {
            return this.name;
        }

        public ColumnType toColumnType() {
            switch (this) {
                case BOOLEAN: {
                    return ColumnType.BOOLEAN;
                }
                case FIXED_INT_64: {
                    return ColumnType.LONG;
                }
                case DOUBLE: {
                    return ColumnType.DOUBLE;
                }
                case VARIABLE_BINARY: {
                    return ColumnType.STRING;
                }
            }
            throw new IllegalStateException("Unknown type " + this);
        }

        public static Type fromColumnType(ColumnType type) {
            switch (type) {
                case BOOLEAN: {
                    return BOOLEAN;
                }
                case DOUBLE: {
                    return DOUBLE;
                }
                case LONG: {
                    return FIXED_INT_64;
                }
                case STRING: {
                    return VARIABLE_BINARY;
                }
            }
            throw new IllegalStateException("Unknown type " + type);
        }

        @JsonCreator
        public static Type fromName(String name) {
            Preconditions.checkNotNull((Object)name, (Object)"name is null");
            Type encoding = NAMES.get(name);
            Preconditions.checkArgument((encoding != null ? 1 : 0) != 0, (String)"Invalid type name: %s", (Object[])new Object[]{name});
            return encoding;
        }

        public static Function<Type, String> nameGetter() {
            return new Function<Type, String>(){

                public String apply(Type type) {
                    return type.getName();
                }
            };
        }

        static {
            NAMES = Maps.uniqueIndex(Arrays.asList(Type.values()), Type.nameGetter());
        }
    }
}

