/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tuple;

import com.facebook.presto.sql.tree.SortItem;
import com.facebook.presto.tuple.TupleInfo;
import com.facebook.presto.tuple.TupleReadable;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Comparator;
import java.util.List;

public class FieldOrderedTupleComparator
implements Comparator<TupleReadable> {
    private final List<Integer> sortFields;
    private final List<SortItem.Ordering> sortOrders;

    public FieldOrderedTupleComparator(List<Integer> sortFields, List<SortItem.Ordering> sortOrders) {
        Preconditions.checkNotNull(sortFields, (Object)"sortFields is null");
        Preconditions.checkNotNull(sortOrders, (Object)"sortOrders is null");
        Preconditions.checkArgument((sortFields.size() == sortOrders.size() ? 1 : 0) != 0, (String)"sortFields size (%s) doesn't match sortOrders size (%s)", (Object[])new Object[]{sortFields.size(), sortOrders.size()});
        this.sortFields = ImmutableList.copyOf(sortFields);
        this.sortOrders = ImmutableList.copyOf(sortOrders);
    }

    @Override
    public int compare(TupleReadable o1, TupleReadable o2) {
        List<TupleInfo.Type> types = o1.getTupleInfo().getTypes();
        for (int index = 0; index < this.sortFields.size(); ++index) {
            int comparison;
            int field = this.sortFields.get(index);
            SortItem.Ordering order = this.sortOrders.get(index);
            TupleInfo.Type type = types.get(field);
            switch (type) {
                case BOOLEAN: {
                    comparison = Boolean.compare(o1.getBoolean(field), o2.getBoolean(field));
                    break;
                }
                case FIXED_INT_64: {
                    comparison = Long.compare(o1.getLong(field), o2.getLong(field));
                    break;
                }
                case DOUBLE: {
                    comparison = Double.compare(o1.getDouble(field), o2.getDouble(field));
                    break;
                }
                case VARIABLE_BINARY: {
                    comparison = o1.getSlice(field).compareTo(o2.getSlice(field));
                    break;
                }
                default: {
                    throw new AssertionError((Object)("unimplemented type: " + type));
                }
            }
            if (comparison == 0) continue;
            if (order == SortItem.Ordering.DESCENDING) {
                return -comparison;
            }
            return comparison;
        }
        return 0;
    }
}

