/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tpch;

import com.facebook.presto.metadata.Node;
import com.facebook.presto.metadata.NodeManager;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorSplitManager;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.Partition;
import com.facebook.presto.spi.Split;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.tpch.TpchSplit;
import com.facebook.presto.tpch.TpchTableHandle;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;

public class TpchSplitManager
implements ConnectorSplitManager {
    private final String connectorId;
    private final NodeManager nodeManager;

    @Inject
    public TpchSplitManager(String connectorId, NodeManager nodeManager) {
        this.connectorId = connectorId;
        this.nodeManager = nodeManager;
    }

    public String getConnectorId() {
        return this.connectorId;
    }

    public boolean canHandle(TableHandle handle) {
        return handle instanceof TpchTableHandle;
    }

    public List<Partition> getPartitions(TableHandle table, Map<ColumnHandle, Object> bindings) {
        return ImmutableList.of((Object)new TpchPartition((TpchTableHandle)table));
    }

    public Iterable<Split> getPartitionSplits(TableHandle table, List<Partition> partitions) {
        Preconditions.checkNotNull(partitions, (Object)"partitions is null");
        if (partitions.isEmpty()) {
            return ImmutableList.of();
        }
        Partition partition = (Partition)Iterables.getOnlyElement(partitions);
        Preconditions.checkArgument((boolean)(partition instanceof TpchPartition), (Object)"Partition must be a tpch partition");
        TpchTableHandle tableHandle = ((TpchPartition)partition).getTable();
        Set<Node> nodes = this.nodeManager.getAllNodes().getActiveNodes();
        int totalParts = nodes.size();
        int partNumber = 0;
        ImmutableList.Builder splits = ImmutableList.builder();
        for (Node node : nodes) {
            TpchSplit tpchSplit = new TpchSplit(tableHandle, partNumber++, totalParts, (List<HostAddress>)ImmutableList.of((Object)node.getHostAndPort()));
            splits.add((Object)tpchSplit);
        }
        return splits.build();
    }

    public static class TpchPartition
    implements Partition {
        private final TpchTableHandle table;

        public TpchPartition(TpchTableHandle table) {
            this.table = table;
        }

        public TpchTableHandle getTable() {
            return this.table;
        }

        public String getPartitionId() {
            return this.table.getTableName();
        }

        public Map<ColumnHandle, Object> getKeys() {
            return ImmutableMap.of();
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("table", (Object)this.table).toString();
        }
    }
}

