/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tpch;

import com.facebook.presto.block.BlockIterable;
import com.facebook.presto.operator.AlignmentOperator;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.serde.BlocksFileEncoding;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.Split;
import com.facebook.presto.split.ConnectorDataStreamProvider;
import com.facebook.presto.tpch.TpchBlocksProvider;
import com.facebook.presto.tpch.TpchColumnHandle;
import com.facebook.presto.tpch.TpchSplit;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.inject.Inject;

public class TpchDataStreamProvider
implements ConnectorDataStreamProvider {
    private final TpchBlocksProvider tpchBlocksProvider;

    @Inject
    public TpchDataStreamProvider(TpchBlocksProvider tpchBlocksProvider) {
        this.tpchBlocksProvider = (TpchBlocksProvider)Preconditions.checkNotNull((Object)tpchBlocksProvider, (Object)"tpchBlocksProvider is null");
    }

    @Override
    public boolean canHandle(Split split) {
        return split instanceof TpchSplit;
    }

    @Override
    public Operator createNewDataStream(OperatorContext operatorContext, Split split, List<ColumnHandle> columns) {
        return new AlignmentOperator(operatorContext, this.getChannels(split, columns));
    }

    private List<BlockIterable> getChannels(Split split, List<ColumnHandle> columns) {
        Preconditions.checkNotNull((Object)split, (Object)"split is null");
        Preconditions.checkArgument((boolean)(split instanceof TpchSplit), (Object)"Split must be a tpch split!");
        Preconditions.checkNotNull(columns, (Object)"columns is null");
        Preconditions.checkArgument((!columns.isEmpty() ? 1 : 0) != 0, (Object)"must provide at least one column");
        TpchSplit tpchSplit = (TpchSplit)split;
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ColumnHandle column : columns) {
            Preconditions.checkArgument((boolean)(column instanceof TpchColumnHandle), (String)"column must be of type TpchColumnHandle, not %s", (Object[])new Object[]{column.getClass().getName()});
            builder.add((Object)this.tpchBlocksProvider.getBlocks(tpchSplit.getTableHandle(), (TpchColumnHandle)column, tpchSplit.getPartNumber(), tpchSplit.getTotalParts(), BlocksFileEncoding.RAW));
        }
        return builder.build();
    }
}

