/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tpch;

import com.facebook.presto.block.BlockIterable;
import com.facebook.presto.serde.BlocksFileEncoding;
import com.facebook.presto.serde.BlocksFileReader;
import com.facebook.presto.tpch.TpchBlocksProvider;
import com.facebook.presto.tpch.TpchColumnHandle;
import com.facebook.presto.tpch.TpchDataFileLoader;
import com.facebook.presto.tpch.TpchTableHandle;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.File;

public class DataFileTpchBlocksProvider
implements TpchBlocksProvider {
    private static final LoadingCache<String, Slice> mappedFileCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, Slice>(){

        public Slice load(String key) throws Exception {
            File file = new File(key);
            Slice slice = Slices.mapFileReadOnly((File)file);
            return slice;
        }
    });
    private final TpchDataFileLoader tpchDataFileLoader;

    public DataFileTpchBlocksProvider(TpchDataFileLoader tpchDataFileLoader) {
        this.tpchDataFileLoader = (TpchDataFileLoader)Preconditions.checkNotNull((Object)tpchDataFileLoader, (Object)"tpchDataProvider is null");
    }

    @Override
    public BlockIterable getBlocks(TpchTableHandle tableHandle, TpchColumnHandle columnHandle, int partNumber, int totalParts, BlocksFileEncoding encoding) {
        Preconditions.checkArgument((totalParts > 0 ? 1 : 0) != 0, (Object)"totalParts must be > 1");
        Preconditions.checkArgument((partNumber >= 0 ? 1 : 0) != 0, (Object)"partNumber must be >= 0");
        Slice slice = this.getColumnSlice(tableHandle, columnHandle, encoding);
        return BlocksFileReader.readBlocks(slice);
    }

    private Slice getColumnSlice(TpchTableHandle tableHandle, TpchColumnHandle columnHandle, BlocksFileEncoding encoding) {
        Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
        Preconditions.checkNotNull((Object)columnHandle, (Object)"columnHandle is null");
        Preconditions.checkNotNull((Object)((Object)encoding), (Object)"encoding is null");
        File columnFile = this.tpchDataFileLoader.getDataFile(tableHandle, columnHandle, encoding);
        return (Slice)mappedFileCache.getUnchecked((Object)columnFile.getAbsolutePath());
    }
}

