/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.storage;

import com.facebook.presto.metadata.ForMetadata;
import com.facebook.presto.metadata.NativeTableHandle;
import com.facebook.presto.metadata.QualifiedTableName;
import com.facebook.presto.storage.StorageDao;
import com.facebook.presto.storage.StorageManager;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import org.skife.jdbi.v2.IDBI;

public class DatabaseStorageManager
implements StorageManager {
    private final IDBI dbi;
    private final StorageDao dao;

    @Inject
    DatabaseStorageManager(@ForMetadata IDBI dbi) throws InterruptedException {
        this.dbi = (IDBI)Preconditions.checkNotNull((Object)dbi, (Object)"dbi is null");
        this.dao = (StorageDao)dbi.onDemand(StorageDao.class);
        StorageDao.Utils.createStorageTablesWithRetry(this.dao);
    }

    @Override
    public void insertTableSource(NativeTableHandle tableHandle, QualifiedTableName sourceTableName) {
        Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
        Preconditions.checkNotNull((Object)sourceTableName, (Object)"sourceTableName is null");
        this.dao.insertSourceTable(tableHandle.getTableId(), sourceTableName);
    }

    @Override
    public QualifiedTableName getTableSource(NativeTableHandle tableHandle) {
        Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
        return this.dao.getSourceTable(tableHandle.getTableId());
    }

    @Override
    public void dropTableSource(NativeTableHandle tableHandle) {
        Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
        this.dao.dropSourceTable(tableHandle.getTableId());
    }
}

