/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.sql.planner.DependencyExtractor;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.Immutable;

@Immutable
public class TableScanNode
extends PlanNode {
    private final TableHandle table;
    private final List<Symbol> outputSymbols;
    private final Map<Symbol, ColumnHandle> assignments;
    private final Expression partitionPredicate;
    private final Expression upstreamPredicateHint;

    @JsonCreator
    public TableScanNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="table") TableHandle table, @JsonProperty(value="outputSymbols") List<Symbol> outputSymbols, @JsonProperty(value="assignments") Map<Symbol, ColumnHandle> assignments, @JsonProperty(value="partitionPredicate") Expression partitionPredicate, @JsonProperty(value="upstreamPredicateHint") Expression upstreamPredicateHint) {
        super(id);
        Preconditions.checkNotNull((Object)table, (Object)"table is null");
        Preconditions.checkNotNull(outputSymbols, (Object)"outputSymbols is null");
        Preconditions.checkArgument((!outputSymbols.isEmpty() ? 1 : 0) != 0, (Object)"outputSymbols is empty");
        Preconditions.checkNotNull(assignments, (Object)"assignments is null");
        Preconditions.checkArgument((!assignments.isEmpty() ? 1 : 0) != 0, (Object)"assignments is empty");
        Preconditions.checkNotNull((Object)partitionPredicate, (Object)"partitionPredicate is null");
        Preconditions.checkNotNull((Object)upstreamPredicateHint, (Object)"upstreamPredicateHint is null");
        this.table = table;
        this.outputSymbols = ImmutableList.copyOf(outputSymbols);
        this.assignments = ImmutableMap.copyOf(assignments);
        this.partitionPredicate = partitionPredicate;
        this.upstreamPredicateHint = upstreamPredicateHint;
        Preconditions.checkArgument((boolean)assignments.keySet().containsAll(outputSymbols), (Object)"Assignments must provide mappings for all output symbols");
        Preconditions.checkArgument((boolean)assignments.keySet().containsAll(DependencyExtractor.extractUnique(partitionPredicate)), (Object)"Assignments must provide mappings for all partition predicate symbols");
        Preconditions.checkArgument((boolean)outputSymbols.containsAll(DependencyExtractor.extractUnique(upstreamPredicateHint)), (Object)"Upstream predicate hint must be in terms of output symbols");
    }

    @JsonProperty(value="table")
    public TableHandle getTable() {
        return this.table;
    }

    @JsonProperty(value="assignments")
    public Map<Symbol, ColumnHandle> getAssignments() {
        return this.assignments;
    }

    @JsonProperty(value="partitionPredicate")
    public Expression getPartitionPredicate() {
        return this.partitionPredicate;
    }

    @JsonProperty(value="upstreamPredicateHint")
    public Expression getUpstreamPredicateHint() {
        return this.upstreamPredicateHint;
    }

    @Override
    @JsonProperty(value="outputSymbols")
    public List<Symbol> getOutputSymbols() {
        return this.outputSymbols;
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of();
    }

    @Override
    public <C, R> R accept(PlanVisitor<C, R> visitor, C context) {
        return visitor.visitTableScan(this, context);
    }
}

