/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.facebook.presto.sql.tree.SampledRelation;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
public class SampleNode
extends PlanNode {
    private final PlanNode source;
    private final double sampleRatio;
    private final Type sampleType;

    @JsonCreator
    public SampleNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="sampleRatio") double sampleRatio, @JsonProperty(value="sampleType") Type sampleType) {
        super(id);
        Preconditions.checkArgument((sampleRatio >= 0.0 && sampleRatio <= 1.0 ? 1 : 0) != 0, (Object)"sample ratio must be between 0 and 1");
        this.sampleType = (Type)((Object)Preconditions.checkNotNull((Object)((Object)sampleType), (Object)"sample type is null"));
        this.source = (PlanNode)Preconditions.checkNotNull((Object)source, (Object)"source is null");
        this.sampleRatio = (Double)Preconditions.checkNotNull((Object)sampleRatio, (Object)"sample ratio is null");
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @JsonProperty
    public double getSampleRatio() {
        return this.sampleRatio;
    }

    @JsonProperty
    public Type getSampleType() {
        return this.sampleType;
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return this.source.getOutputSymbols();
    }

    @Override
    public <C, R> R accept(PlanVisitor<C, R> visitor, C context) {
        return visitor.visitSample(this, context);
    }

    public static enum Type {
        BERNOULLI,
        SYSTEM;


        public static Type fromType(SampledRelation.Type sampleType) {
            switch (sampleType) {
                case BERNOULLI: {
                    return BERNOULLI;
                }
                case SYSTEM: {
                    return SYSTEM;
                }
            }
            throw new UnsupportedOperationException("Unsupported sample type: " + sampleType);
        }
    }
}

