/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.metadata.ShardManager;
import com.facebook.presto.metadata.TablePartition;
import com.facebook.presto.operator.TableWriterResult;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.Partition;
import com.facebook.presto.spi.PartitionKey;
import com.facebook.presto.spi.PartitionedSplit;
import com.facebook.presto.spi.Split;
import com.facebook.presto.split.CollocatedSplit;
import com.facebook.presto.split.NativeSplit;
import com.facebook.presto.sql.planner.OutputReceiver;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class TableWriter {
    private final TableWriterNode tableWriterNode;
    private final ShardManager shardManager;
    private final Map<String, PartitionInfo> openPartitions = new ConcurrentHashMap<String, PartitionInfo>();
    private final Map<String, PartitionInfo> finishedPartitions = new ConcurrentHashMap<String, PartitionInfo>();
    private final Map<Long, String> shardsDone = new ConcurrentHashMap<Long, String>();
    private final Set<String> partitionsDone = Sets.newSetFromMap(new ConcurrentHashMap());
    private final AtomicInteger shardsInFlight = new AtomicInteger();
    private AtomicBoolean predicateHandedOut = new AtomicBoolean();
    private final Set<String> remainingPartitions = Sets.newSetFromMap(new ConcurrentHashMap());

    TableWriter(TableWriterNode tableWriterNode, ShardManager shardManager) {
        this.tableWriterNode = (TableWriterNode)Preconditions.checkNotNull((Object)tableWriterNode, (Object)"tableWriterNode is null");
        this.shardManager = (ShardManager)Preconditions.checkNotNull((Object)shardManager, (Object)"shardManager is null");
        this.remainingPartitions.addAll(Collections2.transform(shardManager.getPartitions(tableWriterNode.getTable()), TablePartition.partitionNameGetter()));
    }

    public OutputReceiver getOutputReceiver() {
        return new OutputReceiver(){

            @Override
            public void updateOutput(Object result) {
                TableWriterResult tableWriterResult = TableWriterResult.forMap((Map)result);
                String oldValue = TableWriter.this.shardsDone.put(tableWriterResult.getShardId(), tableWriterResult.getNodeIdentifier());
                Preconditions.checkState((oldValue == null || oldValue.equals(tableWriterResult.getNodeIdentifier()) ? 1 : 0) != 0, (String)"Seen a different node committing a shard (%s vs %s)", (Object[])new Object[]{oldValue, tableWriterResult.getNodeIdentifier()});
                for (Map.Entry entry : TableWriter.this.finishedPartitions.entrySet()) {
                    if (TableWriter.this.partitionsDone.contains(entry.getKey())) continue;
                    TableWriter.this.considerCommittingPartition((String)entry.getKey(), (PartitionInfo)entry.getValue());
                }
            }
        };
    }

    private synchronized void considerCommittingPartition(String partitionName, PartitionInfo partitionInfo) {
        if (this.partitionsDone.contains(partitionName)) {
            return;
        }
        Set<Long> shardIds = partitionInfo.getShardIds();
        if (this.shardsDone.keySet().containsAll(shardIds)) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Long shardId : shardIds) {
                builder.put((Object)shardId, (Object)this.shardsDone.get(shardId));
            }
            this.shardManager.commitPartition(this.tableWriterNode.getTable(), partitionName, partitionInfo.getPartitionKeys(), (Map<Long, String>)builder.build());
            Preconditions.checkState((this.shardsInFlight.addAndGet(-shardIds.size()) >= 0 ? 1 : 0) != 0, (Object)"shards in flight crashed into the ground");
            this.partitionsDone.add(partitionName);
        }
    }

    public Iterable<Split> wrapSplits(PlanNodeId planNodeId, Iterable<Split> splits) {
        return new TableWriterIterable(planNodeId, splits);
    }

    private void addPartitionShard(String partition, boolean lastSplit, List<? extends PartitionKey> partitionKeys, Long shardId) {
        PartitionInfo partitionInfo = this.openPartitions.get(partition);
        ImmutableSet.Builder builder = ImmutableSet.builder();
        if (partitionInfo != null) {
            Set<Long> partitionSplits = partitionInfo.getShardIds();
            builder.addAll(partitionSplits);
        }
        if (shardId != null) {
            builder.add((Object)shardId);
        } else {
            Preconditions.checkState((boolean)lastSplit, (Object)"shardId == null and lastSplit unset!");
        }
        ImmutableSet shardIds = builder.build();
        Preconditions.checkState((shardIds.size() > 0 ? 1 : 0) != 0, (String)"Never saw a split for partition %s", (Object[])new Object[]{partition});
        PartitionInfo newPartitionInfo = new PartitionInfo((Set)shardIds, partitionKeys);
        if (lastSplit) {
            Preconditions.checkState((null == this.finishedPartitions.put(partition, newPartitionInfo) ? 1 : 0) != 0, (String)"Partition %s finished multiple times", (Object[])new Object[]{partition});
            this.openPartitions.remove(partition);
        } else {
            this.openPartitions.put(partition, newPartitionInfo);
        }
    }

    private void finishOpenPartitions() {
        for (String partition : this.openPartitions.keySet()) {
            this.addPartitionShard(partition, true, (List<? extends PartitionKey>)ImmutableList.of(), null);
        }
        Preconditions.checkState((this.openPartitions.size() == 0 ? 1 : 0) != 0, (String)"Still open partitions: %s", (Object[])new Object[]{this.openPartitions});
    }

    private void dropAdditionalPartitions() {
        for (String partition : this.remainingPartitions) {
            this.shardManager.dropPartition(this.tableWriterNode.getTable(), partition);
        }
    }

    public Predicate<Partition> getPartitionPredicate() {
        Preconditions.checkState((!this.predicateHandedOut.getAndSet(true) ? 1 : 0) != 0, (Object)"Predicate can only be handed out once");
        ImmutableSet allPartitions = ImmutableSet.copyOf(this.remainingPartitions);
        return new Predicate<Partition>((Set)allPartitions){
            final /* synthetic */ Set val$allPartitions;
            {
                this.val$allPartitions = set;
            }

            public boolean apply(Partition input) {
                TableWriter.this.remainingPartitions.remove(input.getPartitionId());
                return !this.val$allPartitions.contains(input.getPartitionId());
            }
        };
    }

    private static class PartitionInfo {
        private final Set<Long> shardIds;
        private final List<? extends PartitionKey> partitionKeys;

        private PartitionInfo(Set<Long> shardIds, List<? extends PartitionKey> partitionKeys) {
            this.shardIds = shardIds;
            this.partitionKeys = partitionKeys;
        }

        public Set<Long> getShardIds() {
            return this.shardIds;
        }

        public List<? extends PartitionKey> getPartitionKeys() {
            return this.partitionKeys;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("shardIds", this.shardIds).add("partitionKeys", this.partitionKeys).toString();
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.shardIds, this.partitionKeys});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            PartitionInfo other = (PartitionInfo)obj;
            return Objects.equal(this.shardIds, other.shardIds) && Objects.equal(this.partitionKeys, other.partitionKeys);
        }
    }

    private class TableWriterIterator
    extends AbstractIterator<Split> {
        private final PlanNodeId planNodeId;
        private final Iterator<Split> sourceIterator;

        private TableWriterIterator(PlanNodeId planNodeId, Iterator<Split> sourceIterator) {
            this.planNodeId = planNodeId;
            this.sourceIterator = sourceIterator;
        }

        protected Split computeNext() {
            if (this.sourceIterator.hasNext()) {
                Split sourceSplit = this.sourceIterator.next();
                NativeSplit writingSplit = new NativeSplit(TableWriter.this.shardManager.allocateShard(TableWriter.this.tableWriterNode.getTable()), (List<HostAddress>)ImmutableList.of());
                String partition = "unpartitioned";
                boolean lastSplit = false;
                Object partitionKeys = ImmutableList.of();
                if (sourceSplit instanceof PartitionedSplit) {
                    PartitionedSplit partitionedSplit = (PartitionedSplit)sourceSplit;
                    partition = partitionedSplit.getPartitionId();
                    lastSplit = partitionedSplit.isLastSplit();
                    partitionKeys = partitionedSplit.getPartitionKeys();
                }
                TableWriter.this.addPartitionShard(partition, lastSplit, (List)partitionKeys, writingSplit.getShardId());
                CollocatedSplit collocatedSplit = new CollocatedSplit((Map<PlanNodeId, Split>)ImmutableMap.of((Object)this.planNodeId, (Object)sourceSplit, (Object)TableWriter.this.tableWriterNode.getId(), (Object)writingSplit), sourceSplit.getAddresses(), sourceSplit.isRemotelyAccessible());
                TableWriter.this.shardsInFlight.incrementAndGet();
                return collocatedSplit;
            }
            TableWriter.this.finishOpenPartitions();
            TableWriter.this.dropAdditionalPartitions();
            return (Split)this.endOfData();
        }
    }

    private class TableWriterIterable
    implements Iterable<Split> {
        private final AtomicBoolean used = new AtomicBoolean();
        private final Iterable<Split> splits;
        private final PlanNodeId planNodeId;

        private TableWriterIterable(PlanNodeId planNodeId, Iterable<Split> splits) {
            this.planNodeId = (PlanNodeId)Preconditions.checkNotNull((Object)planNodeId, (Object)"planNodeId is null");
            this.splits = (Iterable)Preconditions.checkNotNull(splits, (Object)"splits is null");
        }

        @Override
        public Iterator<Split> iterator() {
            Preconditions.checkState((!this.used.getAndSet(true) ? 1 : 0) != 0, (Object)"The table writer can hand out only a single iterator");
            return new TableWriterIterator(this.planNodeId, this.splits.iterator());
        }
    }
}

