/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.SubPlan;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.SymbolExtractor;
import com.facebook.presto.sql.planner.plan.PlanFragmentId;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class SubPlanBuilder {
    private final PlanFragmentId id;
    private PlanNode root;
    private PlanNodeId partitionedSource;
    private List<SubPlan> children = new ArrayList<SubPlan>();
    private final SymbolAllocator allocator;

    public SubPlanBuilder(PlanFragmentId id, SymbolAllocator allocator, PlanNode root) {
        Preconditions.checkNotNull((Object)id, (Object)"id is null");
        Preconditions.checkNotNull((Object)allocator, (Object)"allocator is null");
        Preconditions.checkNotNull((Object)root, (Object)"root is null");
        this.allocator = allocator;
        this.id = id;
        this.root = root;
    }

    public PlanFragmentId getId() {
        return this.id;
    }

    public PlanNode getRoot() {
        return this.root;
    }

    public SubPlanBuilder setRoot(PlanNode root) {
        Preconditions.checkNotNull((Object)root, (Object)"root is null");
        this.root = root;
        return this;
    }

    public boolean isPartitioned() {
        return this.partitionedSource != null;
    }

    public PlanNodeId getPartitionedSource() {
        return this.partitionedSource;
    }

    public SubPlanBuilder setPartitionedSource(PlanNodeId partitionedSource) {
        this.partitionedSource = partitionedSource;
        return this;
    }

    public SubPlanBuilder setUnpartitionedSource() {
        this.partitionedSource = null;
        return this;
    }

    public List<SubPlan> getChildren() {
        return this.children;
    }

    public SubPlanBuilder setChildren(Iterable<SubPlan> children) {
        this.children = Lists.newArrayList(children);
        return this;
    }

    public SubPlanBuilder addChild(SubPlan child) {
        this.children.add(child);
        return this;
    }

    public SubPlan build() {
        Set<Symbol> dependencies = SymbolExtractor.extract(this.root);
        PlanFragment fragment = new PlanFragment(this.id, this.partitionedSource, Maps.filterKeys(this.allocator.getTypes(), (Predicate)Predicates.in(dependencies)), this.root);
        return new SubPlan(fragment, this.children);
    }
}

